/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractGraphTest {
    protected RDF factory;
    protected Graph graph;
    protected IRI alice;
    protected IRI bob;
    protected IRI name;
    protected IRI knows;
    protected IRI member;
    protected BlankNode bnode1;
    protected BlankNode bnode2;
    protected Literal aliceName;
    protected Literal bobName;
    protected Literal secretClubName;
    protected Literal companyName;
    protected Triple bobNameTriple;

    protected abstract RDF createFactory();

    @Before
    public void createGraphAndAdd() {
        this.factory = this.createFactory();
        this.graph = this.factory.createGraph();
        Assert.assertEquals((long)0L, (long)this.graph.size());
        this.alice = this.factory.createIRI("http://example.com/alice");
        this.bob = this.factory.createIRI("http://example.com/bob");
        this.name = this.factory.createIRI("http://xmlns.com/foaf/0.1/name");
        this.knows = this.factory.createIRI("http://xmlns.com/foaf/0.1/knows");
        this.member = this.factory.createIRI("http://xmlns.com/foaf/0.1/member");
        try {
            this.bnode1 = this.factory.createBlankNode("org1");
            this.bnode2 = this.factory.createBlankNode("org2");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.secretClubName = this.factory.createLiteral("The Secret Club");
            this.companyName = this.factory.createLiteral("A company");
            this.aliceName = this.factory.createLiteral("Alice");
            this.bobName = this.factory.createLiteral("Bob", "en-US");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (this.aliceName != null) {
            this.graph.add((BlankNodeOrIRI)this.alice, this.name, (RDFTerm)this.aliceName);
        }
        this.graph.add((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        if (this.bnode1 != null) {
            this.graph.add((BlankNodeOrIRI)this.alice, this.member, (RDFTerm)this.bnode1);
        }
        if (this.bobName != null) {
            try {
                this.bobNameTriple = this.factory.createTriple((BlankNodeOrIRI)this.bob, this.name, (RDFTerm)this.bobName);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (this.bobNameTriple != null) {
                this.graph.add(this.bobNameTriple);
            }
        }
        if (this.bnode1 != null) {
            this.graph.add(this.factory.createTriple((BlankNodeOrIRI)this.bob, this.member, (RDFTerm)this.bnode1));
            this.graph.add(this.factory.createTriple((BlankNodeOrIRI)this.bob, this.member, (RDFTerm)this.bnode2));
            if (this.secretClubName != null) {
                this.graph.add((BlankNodeOrIRI)this.bnode1, this.name, (RDFTerm)this.secretClubName);
                this.graph.add((BlankNodeOrIRI)this.bnode2, this.name, (RDFTerm)this.companyName);
            }
        }
    }

    @Test
    public void size() throws Exception {
        Assert.assertTrue((this.graph.size() > 0L ? 1 : 0) != 0);
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.aliceName, this.bobName, this.secretClubName, this.companyName, this.bobNameTriple});
        Assert.assertEquals((long)8L, (long)this.graph.size());
    }

    @Test
    public void iterate() throws Exception {
        Assume.assumeTrue((this.graph.size() > 0L ? 1 : 0) != 0);
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (Triple t : this.graph.iterate()) {
            triples.add(t);
        }
        Assert.assertEquals((long)this.graph.size(), (long)triples.size());
        if (this.bobNameTriple != null) {
            Assert.assertTrue((boolean)triples.contains(this.bobNameTriple));
        }
        Iterable iterate = this.graph.iterate();
        Iterator it = iterate.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        this.closeIterable(iterate);
        long count = 0L;
        Iterable iterable = this.graph.iterate();
        for (Triple t : iterable) {
            ++count;
        }
        Assert.assertEquals((long)this.graph.size(), (long)count);
    }

    private void closeIterable(Iterable<Triple> iterate) throws Exception {
        if (iterate instanceof AutoCloseable) {
            ((AutoCloseable)((Object)iterate)).close();
        }
    }

    @Test
    public void iterateFilter() throws Exception {
        ArrayList<RDFTerm> friends = new ArrayList<RDFTerm>();
        IRI alice = this.factory.createIRI("http://example.com/alice");
        IRI knows = this.factory.createIRI("http://xmlns.com/foaf/0.1/knows");
        for (Triple t : this.graph.iterate((BlankNodeOrIRI)alice, knows, null)) {
            friends.add(t.getObject());
        }
        Assert.assertEquals((long)1L, (long)friends.size());
        Assert.assertEquals((Object)this.bob, friends.get(0));
        Iterable iterate = this.graph.iterate((BlankNodeOrIRI)this.bob, knows, (RDFTerm)alice);
        for (Triple unexpected : iterate) {
            Assert.fail((String)("Unexpected triple " + unexpected));
        }
    }

    @Test
    public void contains() throws Exception {
        Assert.assertFalse((boolean)this.graph.contains((BlankNodeOrIRI)this.bob, this.knows, (RDFTerm)this.alice));
        Assert.assertTrue((boolean)this.graph.contains((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob));
        try (Stream stream = this.graph.stream();){
            Optional first = stream.skip(4L).findFirst();
            Assume.assumeTrue((boolean)first.isPresent());
            Triple existingTriple = (Triple)first.get();
            Assert.assertTrue((boolean)this.graph.contains(existingTriple));
        }
        Triple nonExistingTriple = this.factory.createTriple((BlankNodeOrIRI)this.bob, this.knows, (RDFTerm)this.alice);
        Assert.assertFalse((boolean)this.graph.contains(nonExistingTriple));
        Triple triple = null;
        try {
            triple = this.factory.createTriple((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (triple != null) {
            // empty if block
        }
    }

    @Test
    public void remove() throws Exception {
        Triple otherTriple;
        long fullSize = this.graph.size();
        this.graph.remove((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        long shrunkSize = this.graph.size();
        Assert.assertEquals((long)1L, (long)(fullSize - shrunkSize));
        this.graph.remove((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertEquals((long)shrunkSize, (long)this.graph.size());
        this.graph.add((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        this.graph.add((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        this.graph.add((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertTrue((this.graph.size() > shrunkSize ? 1 : 0) != 0);
        this.graph.remove((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob);
        Assert.assertEquals((long)shrunkSize, (long)this.graph.size());
        try (Stream stream = this.graph.stream();){
            Optional anyTriple = stream.findAny();
            Assume.assumeTrue((boolean)anyTriple.isPresent());
            otherTriple = (Triple)anyTriple.get();
        }
        this.graph.remove(otherTriple);
        Assert.assertEquals((long)(shrunkSize - 1L), (long)this.graph.size());
        this.graph.remove(otherTriple);
        Assert.assertEquals((long)(shrunkSize - 1L), (long)this.graph.size());
        this.graph.add(otherTriple);
        Assert.assertTrue((this.graph.size() >= shrunkSize ? 1 : 0) != 0);
    }

    @Test
    public void clear() throws Exception {
        this.graph.clear();
        Assert.assertFalse((boolean)this.graph.contains((BlankNodeOrIRI)this.alice, this.knows, (RDFTerm)this.bob));
        Assert.assertEquals((long)0L, (long)this.graph.size());
        this.graph.clear();
        Assert.assertEquals((long)0L, (long)this.graph.size());
    }

    @Test
    public void getTriples() throws Exception {
        long tripleCount;
        try (Stream stream = this.graph.stream();){
            tripleCount = stream.count();
        }
        Assert.assertTrue((tripleCount > 0L ? 1 : 0) != 0);
        stream = this.graph.stream();
        var4_2 = null;
        try {
            Assert.assertTrue((boolean)stream.allMatch(t -> this.graph.contains(t)));
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var4_2 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.aliceName, this.bobName, this.secretClubName, this.companyName, this.bobNameTriple});
        Assert.assertEquals((long)8L, (long)tripleCount);
    }

    @Test
    public void getTriplesQuery() throws Exception {
        try (Stream stream = this.graph.stream((BlankNodeOrIRI)this.alice, null, null);){
            long aliceCount = stream.count();
            Assert.assertTrue((aliceCount > 0L ? 1 : 0) != 0);
            Assume.assumeNotNull((Object[])new Object[]{this.aliceName});
            Assert.assertEquals((long)3L, (long)aliceCount);
        }
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.bobName, this.companyName, this.secretClubName});
        stream = this.graph.stream(null, this.name, null);
        var2_2 = null;
        try {
            Assert.assertEquals((long)4L, (long)stream.count());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var2_2 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1});
        stream = this.graph.stream(null, this.member, null);
        var2_2 = null;
        try {
            Assert.assertEquals((long)3L, (long)stream.count());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var2_2 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    public void addBlankNodesFromMultipleGraphs() throws Exception {
        try (Graph g1 = this.createGraph1();
             Graph g2 = this.createGraph2();
             Graph g3 = this.factory.createGraph();){
            this.addAllTriples(g1, g3);
            this.addAllTriples(g2, g3);
            ConcurrentHashMap whoIsWho = new ConcurrentHashMap();
            IRI name = this.factory.createIRI("http://xmlns.com/foaf/0.1/name");
            try (Stream stream = g3.stream(null, name, null);){
                ((Stream)stream.parallel()).forEach(t -> whoIsWho.put(t.getObject().ntriplesString(), t.getSubject()));
            }
            Assert.assertEquals((long)4L, (long)whoIsWho.size());
            Assert.assertEquals((long)4L, (long)new HashSet(whoIsWho.values()).size());
            BlankNodeOrIRI b1Alice = (BlankNodeOrIRI)whoIsWho.get("\"Alice\"");
            Assert.assertNotNull((Object)b1Alice);
            BlankNodeOrIRI b2Bob = (BlankNodeOrIRI)whoIsWho.get("\"Bob\"");
            Assert.assertNotNull((Object)b2Bob);
            BlankNodeOrIRI b1Charlie = (BlankNodeOrIRI)whoIsWho.get("\"Charlie\"");
            Assert.assertNotNull((Object)b1Charlie);
            BlankNodeOrIRI b2Dave = (BlankNodeOrIRI)whoIsWho.get("\"Dave\"");
            Assert.assertNotNull((Object)b2Dave);
            this.notEquals(b1Alice, b2Bob);
            this.notEquals(b1Alice, b1Charlie);
            this.notEquals(b1Alice, b2Dave);
            this.notEquals(b2Bob, b1Charlie);
            this.notEquals(b2Bob, b2Dave);
            this.notEquals(b1Charlie, b2Dave);
            IRI hasChild = this.factory.createIRI("http://example.com/hasChild");
            Assert.assertTrue((boolean)g3.contains(b1Alice, hasChild, (RDFTerm)b2Bob));
            Assert.assertTrue((boolean)g3.contains(b2Dave, hasChild, (RDFTerm)b1Charlie));
            Assert.assertFalse((boolean)g3.contains(b1Alice, hasChild, (RDFTerm)b1Alice));
            Assert.assertFalse((boolean)g3.contains(b1Alice, hasChild, (RDFTerm)b1Charlie));
            Assert.assertFalse((boolean)g3.contains(b1Alice, hasChild, (RDFTerm)b2Dave));
            Assert.assertFalse((boolean)g3.contains(b2Dave, hasChild, (RDFTerm)b1Alice));
            Assert.assertFalse((boolean)g3.contains(b2Dave, hasChild, (RDFTerm)b1Alice));
            Assert.assertFalse((boolean)g3.contains(b2Bob, hasChild, null));
            Assert.assertFalse((boolean)g3.contains(b1Charlie, hasChild, null));
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    @Test
    public void containsLanguageTagsCaseInsensitive() throws Exception {
        Literal lower = this.factory.createLiteral("Hello", "en-gb");
        Literal upper = this.factory.createLiteral("Hello", "EN-GB");
        Literal mixed = this.factory.createLiteral("Hello", "en-GB");
        IRI example1 = this.factory.createIRI("http://example.com/s1");
        IRI greeting = this.factory.createIRI("http://example.com/greeting");
        try (Graph graph = this.factory.createGraph();){
            graph.add((BlankNodeOrIRI)example1, greeting, (RDFTerm)upper);
            Assert.assertTrue((boolean)graph.contains(this.factory.createTriple((BlankNodeOrIRI)example1, greeting, (RDFTerm)upper)));
            Assert.assertTrue((boolean)graph.contains(this.factory.createTriple((BlankNodeOrIRI)example1, greeting, (RDFTerm)lower)));
            Assert.assertTrue((boolean)graph.contains(this.factory.createTriple((BlankNodeOrIRI)example1, greeting, (RDFTerm)mixed)));
            Assert.assertTrue((boolean)graph.contains(null, null, (RDFTerm)upper));
            Assert.assertTrue((boolean)graph.contains(null, null, (RDFTerm)lower));
            Assert.assertTrue((boolean)graph.contains(null, null, (RDFTerm)mixed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void containsLanguageTagsCaseInsensitiveTurkish() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        try (Graph g = this.factory.createGraph();){
            Locale.setDefault(Locale.ROOT);
            Literal lowerROOT = this.factory.createLiteral("moi", "fi");
            Literal upperROOT = this.factory.createLiteral("moi", "FI");
            Literal mixedROOT = this.factory.createLiteral("moi", "fI");
            IRI exampleROOT = this.factory.createIRI("http://example.com/s1");
            IRI greeting = this.factory.createIRI("http://example.com/greeting");
            g.add((BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)mixedROOT);
            Locale turkish = Locale.forLanguageTag("TR");
            Locale.setDefault(turkish);
            Assume.assumeFalse((boolean)"FI".toLowerCase().equals("fi"));
            Literal lower = this.factory.createLiteral("moi", "fi");
            Literal upper = this.factory.createLiteral("moi", "FI");
            Literal mixed = this.factory.createLiteral("moi", "fI");
            IRI exampleTR = this.factory.createIRI("http://example.com/s2");
            g.add((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)upper);
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)upper)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)upperROOT)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)lower)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)lowerROOT)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)mixed)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleTR, greeting, (RDFTerm)mixedROOT)));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleTR, null, (RDFTerm)upper));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleTR, null, (RDFTerm)upperROOT));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleTR, null, (RDFTerm)lower));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleTR, null, (RDFTerm)lowerROOT));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleTR, null, (RDFTerm)mixed));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleTR, null, (RDFTerm)mixedROOT));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)upper)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)lower)));
            Assert.assertTrue((boolean)g.contains(this.factory.createTriple((BlankNodeOrIRI)exampleROOT, greeting, (RDFTerm)mixed)));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleROOT, null, (RDFTerm)upper));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleROOT, null, (RDFTerm)lower));
            Assert.assertTrue((boolean)g.contains((BlankNodeOrIRI)exampleROOT, null, (RDFTerm)mixed));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void removeLanguageTagsCaseInsensitive() throws Exception {
        Literal lower = this.factory.createLiteral("Hello", "en-gb");
        Literal upper = this.factory.createLiteral("Hello", "EN-GB");
        Literal mixed = this.factory.createLiteral("Hello", "en-GB");
        IRI example1 = this.factory.createIRI("http://example.com/s1");
        IRI greeting = this.factory.createIRI("http://example.com/greeting");
        try (Graph graph = this.factory.createGraph();){
            graph.add((BlankNodeOrIRI)example1, greeting, (RDFTerm)upper);
            graph.remove((BlankNodeOrIRI)example1, null, (RDFTerm)mixed);
            Assert.assertFalse((boolean)graph.contains(null, greeting, null));
            graph.add((BlankNodeOrIRI)example1, greeting, (RDFTerm)lower);
            graph.remove((BlankNodeOrIRI)example1, null, (RDFTerm)upper);
            graph.add(this.factory.createTriple((BlankNodeOrIRI)example1, greeting, (RDFTerm)mixed));
            graph.remove(this.factory.createTriple((BlankNodeOrIRI)example1, greeting, (RDFTerm)upper));
            Assert.assertFalse((boolean)graph.contains(null, greeting, null));
        }
    }

    private static Optional<? extends Triple> closableFindAny(Stream<? extends Triple> stream) {
        try (Stream<? extends Triple> s = stream;){
            Optional<? extends Triple> optional = s.findAny();
            return optional;
        }
    }

    @Test
    public void streamLanguageTagsCaseInsensitive() throws Exception {
        Literal lower = this.factory.createLiteral("Hello", "en-gb");
        Literal upper = this.factory.createLiteral("Hello", "EN-GB");
        Literal mixed = this.factory.createLiteral("Hello", "en-GB");
        IRI example1 = this.factory.createIRI("http://example.com/s1");
        IRI greeting = this.factory.createIRI("http://example.com/greeting");
        try (Graph graph = this.factory.createGraph();){
            graph.add((BlankNodeOrIRI)example1, greeting, (RDFTerm)upper);
            Assert.assertTrue((boolean)AbstractGraphTest.closableFindAny(graph.stream(null, null, (RDFTerm)upper)).isPresent());
            Assert.assertTrue((boolean)AbstractGraphTest.closableFindAny(graph.stream(null, null, (RDFTerm)lower)).isPresent());
            Assert.assertTrue((boolean)AbstractGraphTest.closableFindAny(graph.stream(null, null, (RDFTerm)mixed)).isPresent());
            Triple t = AbstractGraphTest.closableFindAny(graph.stream(null, null, (RDFTerm)lower)).get();
            Assert.assertEquals((Object)t, (Object)this.factory.createTriple((BlankNodeOrIRI)example1, greeting, (RDFTerm)mixed));
        }
    }

    private void notEquals(BlankNodeOrIRI node1, BlankNodeOrIRI node2) {
        Assert.assertFalse((boolean)node1.equals(node2));
        Assert.assertFalse((boolean)node1.ntriplesString().equals(node2.ntriplesString()));
    }

    private void addAllTriples(Graph source, Graph target) {
        try (Stream stream = source.stream();){
            ((Stream)((Stream)stream.unordered()).sequential()).forEach(t -> target.add(t));
        }
    }

    private Graph createGraph1() {
        RDF factory1 = this.createFactory();
        IRI name = factory1.createIRI("http://xmlns.com/foaf/0.1/name");
        Graph g1 = factory1.createGraph();
        BlankNode b1 = this.createOwnBlankNode("b1", "0240eaaa-d33e-4fc0-a4f1-169d6ced3680");
        g1.add((BlankNodeOrIRI)b1, name, (RDFTerm)factory1.createLiteral("Alice"));
        BlankNode b2 = this.createOwnBlankNode("b2", "9de7db45-0ce7-4b0f-a1ce-c9680ffcfd9f");
        g1.add((BlankNodeOrIRI)b2, name, (RDFTerm)factory1.createLiteral("Bob"));
        IRI hasChild = factory1.createIRI("http://example.com/hasChild");
        g1.add((BlankNodeOrIRI)b1, hasChild, (RDFTerm)b2);
        return g1;
    }

    private BlankNode createOwnBlankNode(final String name, final String uuid) {
        return new BlankNode(){

            public String ntriplesString() {
                return "_: " + name;
            }

            public String uniqueReference() {
                return uuid;
            }

            public int hashCode() {
                return uuid.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof BlankNode)) {
                    return false;
                }
                BlankNode other = (BlankNode)obj;
                return uuid.equals(other.uniqueReference());
            }
        };
    }

    private Graph createGraph2() {
        RDF factory2 = this.createFactory();
        IRI name = factory2.createIRI("http://xmlns.com/foaf/0.1/name");
        Graph g2 = factory2.createGraph();
        BlankNode b1 = this.createOwnBlankNode("b1", "bc8d3e45-a08f-421d-85b3-c25b373abf87");
        g2.add((BlankNodeOrIRI)b1, name, (RDFTerm)factory2.createLiteral("Charlie"));
        BlankNode b2 = this.createOwnBlankNode("b2", "2209097a-5078-4b03-801a-6a2d2f50d739");
        g2.add((BlankNodeOrIRI)b2, name, (RDFTerm)factory2.createLiteral("Dave"));
        IRI hasChild = factory2.createIRI("http://example.com/hasChild");
        g2.add((BlankNodeOrIRI)b2, hasChild, (RDFTerm)b1);
        return g2;
    }

    @Test
    public void whyJavaStreamsMightNotTakeOverFromSparql() throws Exception {
        Assume.assumeNotNull((Object[])new Object[]{this.bnode1, this.bnode2, this.secretClubName});
        try (Stream stream = this.graph.stream(null, this.knows, null);){
            Assert.assertEquals((Object)"\"The Secret Club\"", (Object)stream.filter(t -> !this.graph.contains((BlankNodeOrIRI)t.getObject(), this.knows, (RDFTerm)t.getSubject())).map(knowsTriple -> {
                try (Stream memberOf = this.graph.stream((BlankNodeOrIRI)knowsTriple.getObject(), this.member, null);){
                    RDFTerm rDFTerm = memberOf.filter(memberTriple -> this.graph.contains(knowsTriple.getSubject(), this.member, memberTriple.getObject())).findFirst().get().getObject();
                    return rDFTerm;
                }
            }).map(org -> {
                try (Stream orgName = this.graph.stream((BlankNodeOrIRI)org, this.name, null);){
                    String string = ((Triple)orgName.findFirst().get()).getObject().ntriplesString();
                    return string;
                }
            }).findFirst().get());
        }
    }
}

