/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRDFTest {
    private RDF factory;

    protected abstract RDF createFactory();

    @Before
    public void setUp() {
        this.factory = this.createFactory();
    }

    @Test
    public void testCreateBlankNode() throws Exception {
        BlankNode bnode = this.factory.createBlankNode();
        BlankNode bnode2 = this.factory.createBlankNode();
        Assert.assertNotEquals((String)"Second blank node has not got a unique internal identifier", (Object)bnode.uniqueReference(), (Object)bnode2.uniqueReference());
    }

    @Test
    public void testCreateBlankNodeIdentifierEmpty() throws Exception {
        try {
            this.factory.createBlankNode("");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateBlankNodeIdentifier() throws Exception {
        this.factory.createBlankNode("example1");
    }

    @Test
    public void testCreateBlankNodeIdentifierTwice() throws Exception {
        BlankNode bnode1 = this.factory.createBlankNode("example1");
        BlankNode bnode2 = this.factory.createBlankNode("example1");
        BlankNode bnode3 = this.factory.createBlankNode("differ");
        Assert.assertEquals((Object)bnode1.uniqueReference(), (Object)bnode2.uniqueReference());
        Assert.assertEquals((Object)bnode1.ntriplesString(), (Object)bnode2.ntriplesString());
        Assert.assertNotEquals((Object)bnode1.uniqueReference(), (Object)bnode3.uniqueReference());
        Assert.assertNotEquals((Object)bnode1.ntriplesString(), (Object)bnode3.ntriplesString());
    }

    @Test
    public void testCreateBlankNodeIdentifierTwiceDifferentFactories() throws Exception {
        BlankNode bnode1 = this.factory.createBlankNode();
        BlankNode differentFactory = this.createFactory().createBlankNode();
        Assert.assertNotEquals((Object)bnode1, (Object)differentFactory);
        Assert.assertNotEquals((Object)bnode1.uniqueReference(), (Object)differentFactory.uniqueReference());
    }

    @Test
    public void testCreateGraph() throws Exception {
        try (Graph graph = this.factory.createGraph();
             Graph graph2 = this.factory.createGraph();){
            Assert.assertEquals((String)"Graph was not empty", (long)0L, (long)graph.size());
            graph.add((BlankNodeOrIRI)this.factory.createBlankNode(), this.factory.createIRI("http://example.com/"), (RDFTerm)this.factory.createBlankNode());
            Assert.assertNotSame((Object)graph, (Object)graph2);
            Assert.assertEquals((String)"Graph was empty after adding", (long)1L, (long)graph.size());
            Assert.assertEquals((String)"New graph was not empty", (long)0L, (long)graph2.size());
        }
    }

    @Test
    public void testCreateIRI() throws Exception {
        IRI example = this.factory.createIRI("http://example.com/");
        Assert.assertEquals((Object)"http://example.com/", (Object)example.getIRIString());
        Assert.assertEquals((Object)"<http://example.com/>", (Object)example.ntriplesString());
        IRI term = this.factory.createIRI("http://example.com/vocab#term");
        Assert.assertEquals((Object)"http://example.com/vocab#term", (Object)term.getIRIString());
        Assert.assertEquals((Object)"<http://example.com/vocab#term>", (Object)term.ntriplesString());
        IRI latin1 = this.factory.createIRI("http://acc\u00e9nt.example.com/premi\u00e8re");
        Assert.assertEquals((Object)"http://acc\u00e9nt.example.com/premi\u00e8re", (Object)latin1.getIRIString());
        Assert.assertEquals((Object)"<http://acc\u00e9nt.example.com/premi\u00e8re>", (Object)latin1.ntriplesString());
        IRI cyrillic = this.factory.createIRI("http://example.\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435/\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430");
        Assert.assertEquals((Object)"http://example.\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435/\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430", (Object)cyrillic.getIRIString());
        Assert.assertEquals((Object)"<http://example.\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435/\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430>", (Object)cyrillic.ntriplesString());
        IRI deseret = this.factory.createIRI("http://\ud801\udc00.example.com/\ud801\udc00");
        Assert.assertEquals((Object)"http://\ud801\udc00.example.com/\ud801\udc00", (Object)deseret.getIRIString());
        Assert.assertEquals((Object)"<http://\ud801\udc00.example.com/\ud801\udc00>", (Object)deseret.ntriplesString());
    }

    @Test
    public void testCreateLiteral() throws Exception {
        Literal example = this.factory.createLiteral("Example");
        Assert.assertEquals((Object)"Example", (Object)example.getLexicalForm());
        Assert.assertFalse((boolean)example.getLanguageTag().isPresent());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema#string", (Object)example.getDatatype().getIRIString());
        Assert.assertEquals((Object)"\"Example\"", (Object)example.ntriplesString());
    }

    @Test
    public void testCreateLiteralDateTime() throws Exception {
        Literal dateTime = this.factory.createLiteral("2014-12-27T00:50:00T-0600", this.factory.createIRI("http://www.w3.org/2001/XMLSchema#dateTime"));
        Assert.assertEquals((Object)"2014-12-27T00:50:00T-0600", (Object)dateTime.getLexicalForm());
        Assert.assertFalse((boolean)dateTime.getLanguageTag().isPresent());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema#dateTime", (Object)dateTime.getDatatype().getIRIString());
        Assert.assertEquals((Object)"\"2014-12-27T00:50:00T-0600\"^^<http://www.w3.org/2001/XMLSchema#dateTime>", (Object)dateTime.ntriplesString());
    }

    @Test
    public void testCreateLiteralLang() throws Exception {
        Literal example = this.factory.createLiteral("Example", "en");
        Assert.assertEquals((Object)"Example", (Object)example.getLexicalForm());
        Assert.assertEquals((Object)"en", example.getLanguageTag().get());
        Assert.assertEquals((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", (Object)example.getDatatype().getIRIString());
        Assert.assertEquals((Object)"\"Example\"@en", (Object)example.ntriplesString());
    }

    @Test
    public void testCreateLiteralLangISO693_3() throws Exception {
        Literal vls = this.factory.createLiteral("Herbert Van de Sompel", "vls");
        Assert.assertEquals((Object)"vls", vls.getLanguageTag().get());
        Assert.assertEquals((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", (Object)vls.getDatatype().getIRIString());
        Assert.assertEquals((Object)"\"Herbert Van de Sompel\"@vls", (Object)vls.ntriplesString());
    }

    private void assertEqualsBothWays(Object a, Object b) {
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((Object)b, (Object)a);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
    }

    @Test
    public void testCreateLiteralLangCaseInsensitive() throws Exception {
        Literal upper = this.factory.createLiteral("Hello", "EN-GB");
        Literal lower = this.factory.createLiteral("Hello", "en-gb");
        Literal mixed = this.factory.createLiteral("Hello", "en-GB");
        Assert.assertEquals((Object)"en-gb", (Object)((String)lower.getLanguageTag().get()).toLowerCase(Locale.ROOT));
        Assert.assertEquals((Object)"en-gb", (Object)((String)upper.getLanguageTag().get()).toLowerCase(Locale.ROOT));
        Assert.assertEquals((Object)"en-gb", (Object)((String)mixed.getLanguageTag().get()).toLowerCase(Locale.ROOT));
        Assert.assertEquals((Object)lower, (Object)lower);
        this.assertEqualsBothWays(lower, upper);
        this.assertEqualsBothWays(lower, mixed);
        Assert.assertEquals((Object)upper, (Object)upper);
        this.assertEqualsBothWays(upper, mixed);
        Assert.assertEquals((Object)mixed, (Object)mixed);
    }

    @Test
    public void testCreateLiteralLangCaseInsensitiveOther() throws Exception {
        Literal upper = this.factory.createLiteral("Hello", "EN-GB");
        Literal lower = this.factory.createLiteral("Hello", "en-gb");
        Literal mixed = this.factory.createLiteral("Hello", "en-GB");
        Literal otherLiteral = new Literal(){

            public String ntriplesString() {
                return "Hello@eN-Gb";
            }

            public String getLexicalForm() {
                return "Hello";
            }

            public Optional<String> getLanguageTag() {
                return Optional.of("eN-Gb");
            }

            public IRI getDatatype() {
                return AbstractRDFTest.this.factory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString");
            }

            public boolean equals(Object obj) {
                throw new RuntimeException("Wrong way comparison of literal");
            }
        };
        Assert.assertEquals((Object)mixed, (Object)otherLiteral);
        Assert.assertEquals((Object)lower, (Object)otherLiteral);
        Assert.assertEquals((Object)upper, (Object)otherLiteral);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateLiteralLangCaseInsensitiveInTurkish() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ROOT);
            Literal mixedROOT = this.factory.createLiteral("moi", "fI");
            Literal lowerROOT = this.factory.createLiteral("moi", "fi");
            Literal upperROOT = this.factory.createLiteral("moi", "FI");
            Locale turkish = Locale.forLanguageTag("TR");
            Locale.setDefault(turkish);
            Assume.assumeFalse((boolean)"FI".toLowerCase().equals("fi"));
            Literal mixed = this.factory.createLiteral("moi", "fI");
            Literal lower = this.factory.createLiteral("moi", "fi");
            Literal upper = this.factory.createLiteral("moi", "FI");
            Assert.assertEquals((Object)lower, (Object)lower);
            this.assertEqualsBothWays(lower, upper);
            this.assertEqualsBothWays(lower, mixed);
            Assert.assertEquals((Object)upper, (Object)upper);
            this.assertEqualsBothWays(upper, mixed);
            Assert.assertEquals((Object)mixed, (Object)mixed);
            this.assertEqualsBothWays(lower, lowerROOT);
            this.assertEqualsBothWays(upper, lowerROOT);
            this.assertEqualsBothWays(mixed, lowerROOT);
            this.assertEqualsBothWays(lower, upperROOT);
            this.assertEqualsBothWays(upper, upperROOT);
            this.assertEqualsBothWays(mixed, upperROOT);
            this.assertEqualsBothWays(lower, mixedROOT);
            this.assertEqualsBothWays(upper, mixedROOT);
            this.assertEqualsBothWays(mixed, mixedROOT);
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void testCreateLiteralString() throws Exception {
        Literal example = this.factory.createLiteral("Example", this.factory.createIRI("http://www.w3.org/2001/XMLSchema#string"));
        Assert.assertEquals((Object)"Example", (Object)example.getLexicalForm());
        Assert.assertFalse((boolean)example.getLanguageTag().isPresent());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema#string", (Object)example.getDatatype().getIRIString());
        Assert.assertEquals((Object)"\"Example\"", (Object)example.ntriplesString());
    }

    @Test
    public void testCreateTripleBnodeBnode() {
        BlankNode subject = this.factory.createBlankNode("b1");
        IRI predicate = this.factory.createIRI("http://example.com/pred");
        BlankNode object = this.factory.createBlankNode("b2");
        Triple triple = this.factory.createTriple((BlankNodeOrIRI)subject, predicate, (RDFTerm)object);
        Assert.assertEquals((Object)subject, (Object)triple.getSubject());
        Assert.assertEquals((Object)predicate, (Object)triple.getPredicate());
        Assert.assertEquals((Object)object, (Object)triple.getObject());
    }

    @Test
    public void testCreateTripleBnodeIRI() {
        BlankNode subject = this.factory.createBlankNode("b1");
        IRI predicate = this.factory.createIRI("http://example.com/pred");
        IRI object = this.factory.createIRI("http://example.com/obj");
        Triple triple = this.factory.createTriple((BlankNodeOrIRI)subject, predicate, (RDFTerm)object);
        Assert.assertEquals((Object)subject, (Object)triple.getSubject());
        Assert.assertEquals((Object)predicate, (Object)triple.getPredicate());
        Assert.assertEquals((Object)object, (Object)triple.getObject());
    }

    @Test
    public void testCreateTripleBnodeTriple() {
        BlankNode subject = this.factory.createBlankNode();
        IRI predicate = this.factory.createIRI("http://example.com/pred");
        Literal object = this.factory.createLiteral("Example", "en");
        Triple triple = this.factory.createTriple((BlankNodeOrIRI)subject, predicate, (RDFTerm)object);
        Assert.assertEquals((Object)subject, (Object)triple.getSubject());
        Assert.assertEquals((Object)predicate, (Object)triple.getPredicate());
        Assert.assertEquals((Object)object, (Object)triple.getObject());
    }

    @Test
    public void testPossiblyInvalidBlankNode() throws Exception {
        BlankNode withColon;
        try {
            withColon = this.factory.createBlankNode("with:colon");
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.assertFalse((boolean)withColon.ntriplesString().contains("with:colon"));
        Assert.assertEquals((Object)withColon.ntriplesString(), (Object)this.factory.createBlankNode("with:colon").ntriplesString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIRI() throws Exception {
        this.factory.createIRI("<no_brackets>");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLiteralLang() throws Exception {
        this.factory.createLiteral("Example", "with space");
    }

    @Test(expected=Exception.class)
    public void testInvalidTriplePredicate() {
        BlankNode subject = this.factory.createBlankNode("b1");
        BlankNode predicate = this.factory.createBlankNode("b2");
        BlankNode object = this.factory.createBlankNode("b3");
        this.factory.createTriple((BlankNodeOrIRI)subject, (IRI)predicate, (RDFTerm)object);
    }

    @Test
    public void hashCodeBlankNode() throws Exception {
        BlankNode bnode1 = this.factory.createBlankNode();
        Assert.assertEquals((long)bnode1.uniqueReference().hashCode(), (long)bnode1.hashCode());
    }

    @Test
    public void hashCodeIRI() throws Exception {
        IRI iri = this.factory.createIRI("http://example.com/");
        Assert.assertEquals((long)iri.getIRIString().hashCode(), (long)iri.hashCode());
    }

    @Test
    public void hashCodeLiteral() throws Exception {
        Literal literal = this.factory.createLiteral("Hello");
        Assert.assertEquals((long)Objects.hash(literal.getLexicalForm(), literal.getDatatype(), literal.getLanguageTag()), (long)literal.hashCode());
    }

    @Test
    public void hashCodeTriple() throws Exception {
        IRI iri = this.factory.createIRI("http://example.com/");
        Triple triple = this.factory.createTriple((BlankNodeOrIRI)iri, iri, (RDFTerm)iri);
        Assert.assertEquals((long)Objects.hash(iri, iri, iri), (long)triple.hashCode());
    }
}

