/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.DummyGraph;
import org.apache.commons.rdf.api.DummyIRI;
import org.apache.commons.rdf.api.DummyTriple;
import org.apache.commons.rdf.api.Triple;
import org.junit.Assert;
import org.junit.Test;

public class DefaultGraphTest {
    DummyGraph graph = new DummyGraph();

    @Test
    public void close() throws Exception {
        this.graph.close();
    }

    @Test
    public void defaultGetTriples() throws Exception {
        Assert.assertFalse((boolean)this.graph.streamCalled);
        Assert.assertFalse((boolean)this.graph.filteredStreamCalled);
        Assert.assertEquals((long)1L, (long)this.graph.getTriples().count());
        Assert.assertTrue((boolean)this.graph.streamCalled);
        Assert.assertFalse((boolean)this.graph.filteredStreamCalled);
    }

    @Test
    public void defaultGetTriplesFiltered() throws Exception {
        Assert.assertFalse((boolean)this.graph.streamCalled);
        Assert.assertFalse((boolean)this.graph.filteredStreamCalled);
        Assert.assertEquals((long)1L, (long)this.graph.getTriples(null, null, null).count());
        Assert.assertFalse((boolean)this.graph.streamCalled);
        Assert.assertTrue((boolean)this.graph.filteredStreamCalled);
        Assert.assertEquals((long)0L, (long)this.graph.getTriples((BlankNodeOrIRI)new DummyIRI(0), null, null).count());
    }

    @Test
    public void defaultIterate() throws Exception {
        Assert.assertFalse((boolean)this.graph.streamCalled);
        Assert.assertFalse((boolean)this.graph.filteredStreamCalled);
        for (Triple t : this.graph.iterate()) {
            Assert.assertEquals((Object)t, (Object)new DummyTriple());
        }
        Assert.assertTrue((boolean)this.graph.streamCalled);
        Assert.assertFalse((boolean)this.graph.filteredStreamCalled);
    }

    @Test
    public void defaultFilteredIterate() throws Exception {
        Assert.assertFalse((boolean)this.graph.streamCalled);
        Assert.assertFalse((boolean)this.graph.filteredStreamCalled);
        for (Triple t : this.graph.iterate(null, new DummyIRI(2), null)) {
            Assert.assertEquals((Object)t, (Object)new DummyTriple());
        }
        Assert.assertTrue((boolean)this.graph.filteredStreamCalled);
        Assert.assertFalse((boolean)this.graph.streamCalled);
    }
}

