/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.DummyGraph;
import org.apache.commons.rdf.api.DummyIRI;
import org.apache.commons.rdf.api.DummyQuad;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;

class DummyDataset
implements Dataset {
    boolean streamCalled = false;
    boolean filteredStreamCalled;

    DummyDataset() {
    }

    public void add(Quad Quad2) {
        if (!this.contains(Quad2)) {
            throw new IllegalStateException("DummyDataset can't be modified");
        }
    }

    public void add(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        if (!this.contains(Optional.ofNullable(graphName), subject, predicate, object)) {
            throw new IllegalStateException("DummyDataset can't be modified");
        }
    }

    public boolean contains(Quad Quad2) {
        return Quad2.equals((Object)new DummyQuad());
    }

    public boolean contains(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return !(graphName != null && graphName.isPresent() || subject != null && !subject.equals(new DummyIRI(1)) || predicate != null && !predicate.equals((Object)new DummyIRI(2)) || object != null && !object.equals((Object)new DummyIRI(3)));
    }

    public void remove(Quad Quad2) {
        if (this.contains(Quad2)) {
            throw new IllegalStateException("DummyDataset can't be modified");
        }
    }

    public void remove(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        if (this.contains(graphName, subject, predicate, object)) {
            throw new IllegalStateException("DummyDataset can't be modified");
        }
    }

    public void clear() {
        throw new IllegalStateException("DummyDataset can't be modified");
    }

    public long size() {
        return 1L;
    }

    public Stream<? extends Quad> stream() {
        this.streamCalled = true;
        return Arrays.asList(new DummyQuad()).stream();
    }

    public Stream<? extends Quad> stream(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.filteredStreamCalled = true;
        if (this.contains(graphName, subject, predicate, object)) {
            return Stream.of(new DummyQuad());
        }
        return Stream.empty();
    }

    public Graph getGraph() {
        return new DummyGraph();
    }

    public Optional<Graph> getGraph(BlankNodeOrIRI graphName) {
        if (graphName == null) {
            return Optional.of(this.getGraph());
        }
        return Optional.empty();
    }

    public Stream<BlankNodeOrIRI> getGraphNames() {
        return Stream.empty();
    }
}

