/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.DummyDataset;
import org.apache.commons.rdf.api.DummyGraph;
import org.apache.commons.rdf.api.DummyIRI;
import org.apache.commons.rdf.api.DummyQuad;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.junit.Assert;
import org.junit.Test;

public class DummyDatasetTest {
    Dataset dataset = new DummyDataset();

    @Test
    public void add() throws Exception {
        this.dataset.add((Quad)new DummyQuad());
    }

    @Test
    public void addSPO() throws Exception {
        this.dataset.add(null, (BlankNodeOrIRI)new DummyIRI(1), (IRI)new DummyIRI(2), (RDFTerm)new DummyIRI(3));
    }

    @Test
    public void contains() throws Exception {
        Assert.assertTrue((boolean)this.dataset.contains((Quad)new DummyQuad()));
    }

    @Test
    public void containsSPO() throws Exception {
        Assert.assertTrue((boolean)this.dataset.contains(null, null, null, null));
        Assert.assertTrue((boolean)this.dataset.contains(null, (BlankNodeOrIRI)new DummyIRI(1), (IRI)new DummyIRI(2), (RDFTerm)new DummyIRI(3)));
        Assert.assertFalse((boolean)this.dataset.contains(null, (BlankNodeOrIRI)new DummyIRI(0), (IRI)new DummyIRI(0), (RDFTerm)new DummyIRI(0)));
    }

    @Test(expected=IllegalStateException.class)
    public void clearNotSupported() throws Exception {
        this.dataset.clear();
    }

    @Test(expected=IllegalStateException.class)
    public void remove() throws Exception {
        this.dataset.remove((Quad)new DummyQuad());
    }

    @Test
    public void removeSPO() throws Exception {
        this.dataset.remove(null, (BlankNodeOrIRI)new DummyIRI(0), (IRI)new DummyIRI(0), (RDFTerm)new DummyIRI(0));
    }

    @Test
    public void size() throws Exception {
        Assert.assertEquals((long)1L, (long)this.dataset.size());
    }

    @Test
    public void stream() throws Exception {
        Assert.assertEquals((Object)new DummyQuad(), this.dataset.stream().findAny().get());
    }

    @Test
    public void streamFiltered() throws Exception {
        Assert.assertEquals((Object)new DummyQuad(), this.dataset.stream(null, null, null, null).findAny().get());
        Assert.assertEquals((Object)new DummyQuad(), this.dataset.stream(null, (BlankNodeOrIRI)new DummyIRI(1), (IRI)new DummyIRI(2), (RDFTerm)new DummyIRI(3)).findAny().get());
        Assert.assertFalse((boolean)this.dataset.stream(null, (BlankNodeOrIRI)new DummyIRI(0), (IRI)new DummyIRI(0), (RDFTerm)new DummyIRI(0)).findAny().isPresent());
    }

    @Test
    public void getGraph() throws Exception {
        Assert.assertTrue((boolean)(this.dataset.getGraph() instanceof DummyGraph));
    }

    @Test
    public void getGraphNull() throws Exception {
        Assert.assertTrue((boolean)(this.dataset.getGraph(null).get() instanceof DummyGraph));
    }

    @Test
    public void getGraphNamed() throws Exception {
        Assert.assertFalse((boolean)this.dataset.getGraph((BlankNodeOrIRI)new DummyIRI(0)).isPresent());
    }

    @Test
    public void getGraphNames() throws Exception {
        Assert.assertFalse((boolean)this.dataset.getGraphNames().findAny().isPresent());
    }
}

