/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.DummyGraph;
import org.apache.commons.rdf.api.DummyIRI;
import org.apache.commons.rdf.api.DummyTriple;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.junit.Assert;
import org.junit.Test;

public class DummyGraphTest {
    Graph graph = new DummyGraph();

    @Test
    public void add() throws Exception {
        this.graph.add((Triple)new DummyTriple());
    }

    @Test
    public void addSPO() throws Exception {
        this.graph.add((BlankNodeOrIRI)new DummyIRI(1), (IRI)new DummyIRI(2), (RDFTerm)new DummyIRI(3));
    }

    @Test
    public void contains() throws Exception {
        Assert.assertTrue((boolean)this.graph.contains((Triple)new DummyTriple()));
    }

    @Test
    public void containsSPO() throws Exception {
        Assert.assertTrue((boolean)this.graph.contains(null, null, null));
        Assert.assertTrue((boolean)this.graph.contains((BlankNodeOrIRI)new DummyIRI(1), (IRI)new DummyIRI(2), (RDFTerm)new DummyIRI(3)));
        Assert.assertFalse((boolean)this.graph.contains((BlankNodeOrIRI)new DummyIRI(0), (IRI)new DummyIRI(0), (RDFTerm)new DummyIRI(0)));
    }

    @Test(expected=IllegalStateException.class)
    public void clearNotSupported() throws Exception {
        this.graph.clear();
    }

    @Test(expected=IllegalStateException.class)
    public void remove() throws Exception {
        this.graph.remove((Triple)new DummyTriple());
    }

    @Test
    public void removeSPO() throws Exception {
        this.graph.remove((BlankNodeOrIRI)new DummyIRI(0), (IRI)new DummyIRI(0), (RDFTerm)new DummyIRI(0));
    }

    @Test
    public void size() throws Exception {
        Assert.assertEquals((long)1L, (long)this.graph.size());
    }

    @Test
    public void stream() throws Exception {
        Assert.assertEquals((Object)new DummyTriple(), this.graph.stream().findAny().get());
    }

    @Test
    public void streamFiltered() throws Exception {
        Assert.assertEquals((Object)new DummyTriple(), this.graph.stream(null, null, null).findAny().get());
        Assert.assertEquals((Object)new DummyTriple(), this.graph.stream((BlankNodeOrIRI)new DummyIRI(1), (IRI)new DummyIRI(2), (RDFTerm)new DummyIRI(3)).findAny().get());
        Assert.assertFalse((boolean)this.graph.stream((BlankNodeOrIRI)new DummyIRI(0), (IRI)new DummyIRI(0), (RDFTerm)new DummyIRI(0)).findAny().isPresent());
    }
}

