/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Optional;
import org.apache.commons.rdf.api.RDFSyntax;
import org.junit.Assert;
import org.junit.Test;

public class RDFSyntaxTest {
    @Test
    public void byFileExtension() throws Exception {
        Assert.assertEquals((Object)RDFSyntax.JSONLD, RDFSyntax.byFileExtension((String)".jsonld").get());
        Assert.assertEquals((Object)RDFSyntax.NQUADS, RDFSyntax.byFileExtension((String)".nq").get());
        Assert.assertEquals((Object)RDFSyntax.NTRIPLES, RDFSyntax.byFileExtension((String)".nt").get());
        Assert.assertEquals((Object)RDFSyntax.RDFA, RDFSyntax.byFileExtension((String)".html").get());
        Assert.assertEquals((Object)RDFSyntax.RDFXML, RDFSyntax.byFileExtension((String)".rdf").get());
        Assert.assertEquals((Object)RDFSyntax.TRIG, RDFSyntax.byFileExtension((String)".trig").get());
        Assert.assertEquals((Object)RDFSyntax.TURTLE, RDFSyntax.byFileExtension((String)".ttl").get());
    }

    @Test
    public void byFileExtensionFailsWithoutDot() throws Exception {
        Assert.assertEquals(Optional.empty(), (Object)RDFSyntax.byFileExtension((String)"rdf"));
    }

    @Test
    public void byFileExtensionLowerCase() throws Exception {
        Assert.assertEquals((Object)RDFSyntax.TURTLE, RDFSyntax.byFileExtension((String)".TtL").get());
    }

    @Test
    public void byFileExtensionUnknown() throws Exception {
        Assert.assertEquals(Optional.empty(), (Object)RDFSyntax.byFileExtension((String)".tar"));
    }

    @Test
    public void byMediaType() throws Exception {
        Assert.assertEquals((Object)RDFSyntax.JSONLD, RDFSyntax.byMediaType((String)"application/ld+json").get());
        Assert.assertEquals((Object)RDFSyntax.NQUADS, RDFSyntax.byMediaType((String)"application/n-quads").get());
        Assert.assertEquals((Object)RDFSyntax.NTRIPLES, RDFSyntax.byMediaType((String)"application/n-triples").get());
        Assert.assertEquals((Object)RDFSyntax.RDFA, RDFSyntax.byMediaType((String)"text/html").get());
        Assert.assertEquals((Object)RDFSyntax.RDFA, RDFSyntax.byMediaType((String)"application/xhtml+xml").get());
        Assert.assertEquals((Object)RDFSyntax.RDFXML, RDFSyntax.byMediaType((String)"application/rdf+xml").get());
        Assert.assertEquals((Object)RDFSyntax.TRIG, RDFSyntax.byMediaType((String)"application/trig").get());
        Assert.assertEquals((Object)RDFSyntax.TURTLE, RDFSyntax.byMediaType((String)"text/turtle").get());
    }

    @Test
    public void byMediaTypeContentType() throws Exception {
        Assert.assertEquals((Object)RDFSyntax.TURTLE, RDFSyntax.byMediaType((String)"text/turtle; charset=\"UTF-8\"").get());
        Assert.assertEquals((Object)RDFSyntax.TURTLE, RDFSyntax.byMediaType((String)"text/turtle ; charset=\"UTF-8\"").get());
        Assert.assertEquals(Optional.empty(), (Object)RDFSyntax.byMediaType((String)"text/turtle, text/plain"));
        Assert.assertEquals(Optional.empty(), (Object)RDFSyntax.byMediaType((String)" text/turtle"));
    }

    @Test
    public void byMediaTypeLowerCase() throws Exception {
        Assert.assertEquals((Object)RDFSyntax.JSONLD, RDFSyntax.byMediaType((String)"APPLICATION/ld+JSON").get());
    }

    @Test
    public void byMediaTypeUnknown() throws Exception {
        Assert.assertEquals(Optional.empty(), (Object)RDFSyntax.byMediaType((String)"application/octet-stream"));
    }

    @Test
    public void fileExtension() throws Exception {
        Assert.assertEquals((Object)".jsonld", (Object)RDFSyntax.JSONLD.fileExtension());
        Assert.assertEquals((Object)".nq", (Object)RDFSyntax.NQUADS.fileExtension());
        Assert.assertEquals((Object)".nt", (Object)RDFSyntax.NTRIPLES.fileExtension());
        Assert.assertEquals((Object)".html", (Object)RDFSyntax.RDFA.fileExtension());
        Assert.assertEquals((Object)".rdf", (Object)RDFSyntax.RDFXML.fileExtension());
        Assert.assertEquals((Object)".trig", (Object)RDFSyntax.TRIG.fileExtension());
        Assert.assertEquals((Object)".ttl", (Object)RDFSyntax.TURTLE.fileExtension());
    }

    @Test
    public void fileExtensions() throws Exception {
        Assert.assertTrue((boolean)RDFSyntax.JSONLD.fileExtensions().contains(".jsonld"));
        Assert.assertTrue((boolean)RDFSyntax.NQUADS.fileExtensions().contains(".nq"));
        Assert.assertTrue((boolean)RDFSyntax.NTRIPLES.fileExtensions().contains(".nt"));
        Assert.assertTrue((boolean)RDFSyntax.RDFA.fileExtensions().contains(".html"));
        Assert.assertTrue((boolean)RDFSyntax.RDFA.fileExtensions().contains(".xhtml"));
        Assert.assertTrue((boolean)RDFSyntax.RDFXML.fileExtensions().contains(".rdf"));
        Assert.assertTrue((boolean)RDFSyntax.TRIG.fileExtensions().contains(".trig"));
        Assert.assertTrue((boolean)RDFSyntax.TURTLE.fileExtensions().contains(".ttl"));
    }

    @Test
    public void mediaType() throws Exception {
        Assert.assertEquals((Object)"application/ld+json", (Object)RDFSyntax.JSONLD.mediaType());
        Assert.assertEquals((Object)"application/n-quads", (Object)RDFSyntax.NQUADS.mediaType());
        Assert.assertEquals((Object)"application/n-triples", (Object)RDFSyntax.NTRIPLES.mediaType());
        Assert.assertEquals((Object)"text/html", (Object)RDFSyntax.RDFA.mediaType());
        Assert.assertEquals((Object)"application/rdf+xml", (Object)RDFSyntax.RDFXML.mediaType());
        Assert.assertEquals((Object)"application/trig", (Object)RDFSyntax.TRIG.mediaType());
        Assert.assertEquals((Object)"text/turtle", (Object)RDFSyntax.TURTLE.mediaType());
    }

    @Test
    public void mediaTypes() throws Exception {
        Assert.assertTrue((boolean)RDFSyntax.JSONLD.mediaTypes().contains("application/ld+json"));
        Assert.assertTrue((boolean)RDFSyntax.NQUADS.mediaTypes().contains("application/n-quads"));
        Assert.assertTrue((boolean)RDFSyntax.NTRIPLES.mediaTypes().contains("application/n-triples"));
        Assert.assertTrue((boolean)RDFSyntax.RDFA.mediaTypes().contains("text/html"));
        Assert.assertTrue((boolean)RDFSyntax.RDFA.mediaTypes().contains("application/xhtml+xml"));
        Assert.assertTrue((boolean)RDFSyntax.RDFXML.mediaTypes().contains("application/rdf+xml"));
        Assert.assertTrue((boolean)RDFSyntax.TRIG.mediaTypes().contains("application/trig"));
        Assert.assertTrue((boolean)RDFSyntax.TURTLE.mediaTypes().contains("text/turtle"));
    }

    @Test
    public void string() throws Exception {
        Assert.assertEquals((Object)"JSON-LD 1.0", (Object)RDFSyntax.JSONLD.toString());
        Assert.assertEquals((Object)"RDF 1.1 Turtle", (Object)RDFSyntax.TURTLE.toString());
    }

    @Test
    public void byName() throws Exception {
        for (RDFSyntax s : RDFSyntax.w3cSyntaxes()) {
            Assert.assertEquals((Object)s, RDFSyntax.byName((String)s.name()).get());
        }
    }
}

