/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFSyntax;

class W3CRDFSyntax
implements RDFSyntax {
    static final RDFSyntax JSONLD = new W3CRDFSyntax("JSON-LD", "JSON-LD 1.0", "application/ld+json", ".jsonld", true);
    static final RDFSyntax TURTLE = new W3CRDFSyntax("Turtle", "RDF 1.1 Turtle", "text/turtle", ".ttl", false);
    static final RDFSyntax NQUADS = new W3CRDFSyntax("N-Quads", "RDF 1.1 N-Quads", "application/n-quads", ".nq", true);
    static final RDFSyntax NTRIPLES = new W3CRDFSyntax("N-Triples", "RDF 1.1 N-Triples", "application/n-triples", ".nt", false);
    static final RDFSyntax RDFA;
    static final RDFSyntax RDFXML;
    static final RDFSyntax TRIG;
    static final Set<RDFSyntax> syntaxes;
    private final String title;
    private final String mediaType;
    private final String fileExtension;
    private final boolean supportsDataset;
    private final String name;
    private final IRI iri;

    private W3CRDFSyntax(String name, String title, String mediaType, String fileExtension, boolean supportsDataset) {
        this.name = name;
        this.title = title;
        this.mediaType = mediaType.toLowerCase(Locale.ROOT);
        this.fileExtension = fileExtension.toLowerCase(Locale.ROOT);
        this.supportsDataset = supportsDataset;
        this.iri = new FormatIRI(name);
    }

    @Override
    public String mediaType() {
        return this.mediaType;
    }

    @Override
    public String fileExtension() {
        return this.fileExtension;
    }

    @Override
    public boolean supportsDataset() {
        return this.supportsDataset;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IRI iri() {
        return this.iri;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFSyntax)) {
            return false;
        }
        RDFSyntax other = (RDFSyntax)obj;
        return this.mediaType.equals(other.mediaType().toLowerCase(Locale.ROOT));
    }

    @Override
    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String toString() {
        return this.title;
    }

    static {
        RDFXML = new W3CRDFSyntax("RDF_XML", "RDF 1.1 XML Syntax", "application/rdf+xml", ".rdf", false);
        TRIG = new W3CRDFSyntax("TriG", "RDF 1.1 TriG", "application/trig", ".trig", true);
        RDFA = new W3CRDFSyntax("RDFa", "HTML+RDFa 1.1", "text/html", ".html", false){
            private final Set<String> types = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("text/html", "application/xhtml+xml")));
            private final Set<String> extensions = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(".html", ".xhtml")));

            @Override
            public Set<String> mediaTypes() {
                return this.types;
            }

            @Override
            public Set<String> fileExtensions() {
                return this.extensions;
            }
        };
        syntaxes = Collections.unmodifiableSet(new LinkedHashSet<RDFSyntax>(Arrays.asList(JSONLD, NQUADS, NTRIPLES, RDFA, RDFXML, TRIG, TURTLE)));
    }

    private static final class FormatIRI
    implements IRI {
        private static String BASE = "http://www.w3.org/ns/formats/";
        private final String format;

        private FormatIRI(String format) {
            this.format = format;
        }

        @Override
        public String getIRIString() {
            return BASE + this.format;
        }

        @Override
        public String ntriplesString() {
            return "<" + this.getIRIString() + ">";
        }

        public String toString() {
            return this.ntriplesString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof IRI)) {
                return false;
            }
            IRI other = (IRI)obj;
            return this.getIRIString().equals(other.getIRIString());
        }

        @Override
        public int hashCode() {
            return this.getIRIString().hashCode();
        }
    }
}

