/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.QuadLike;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.TripleLike;
import org.apache.commons.rdf.jena.ConversionException;
import org.apache.commons.rdf.jena.JenaBlankNode;
import org.apache.commons.rdf.jena.JenaDataset;
import org.apache.commons.rdf.jena.JenaGeneralizedQuadLike;
import org.apache.commons.rdf.jena.JenaGeneralizedTripleLike;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaIRI;
import org.apache.commons.rdf.jena.JenaLiteral;
import org.apache.commons.rdf.jena.JenaQuad;
import org.apache.commons.rdf.jena.JenaQuadLike;
import org.apache.commons.rdf.jena.JenaRDFTerm;
import org.apache.commons.rdf.jena.JenaTriple;
import org.apache.commons.rdf.jena.JenaTripleLike;
import org.apache.commons.rdf.jena.impl.InternalJenaFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;

public final class JenaRDF
implements RDF {
    private static InternalJenaFactory internalJenaFactory = new InternalJenaFactory(){};
    private final UUID salt;

    public JenaRDF() {
        this.salt = UUID.randomUUID();
    }

    public JenaRDF(UUID salt) {
        this.salt = salt;
    }

    public JenaBlankNode createBlankNode() {
        return internalJenaFactory.createBlankNode(this.salt());
    }

    public JenaBlankNode createBlankNode(String name) {
        return internalJenaFactory.createBlankNode(name, this.salt());
    }

    public JenaDataset createDataset() {
        return internalJenaFactory.createDataset(this.salt());
    }

    public JenaGraph createGraph() {
        return internalJenaFactory.createGraph(this.salt());
    }

    public JenaIRI createIRI(String iri) {
        this.validateIRI(iri);
        return internalJenaFactory.createIRI(iri);
    }

    public JenaLiteral createLiteral(String lexicalForm) {
        return internalJenaFactory.createLiteral(lexicalForm);
    }

    public JenaLiteral createLiteral(String lexicalForm, IRI dataType) {
        return internalJenaFactory.createLiteralDT(lexicalForm, dataType.getIRIString());
    }

    public JenaLiteral createLiteral(String lexicalForm, String languageTag) {
        JenaRDF.validateLang(languageTag);
        return internalJenaFactory.createLiteralLang(lexicalForm, languageTag);
    }

    public JenaTriple createTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return internalJenaFactory.createTriple(subject, predicate, object);
    }

    public JenaQuad createQuad(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws IllegalArgumentException, UnsupportedOperationException {
        return internalJenaFactory.createQuad(subject, predicate, object, graphName);
    }

    public JenaGeneralizedTripleLike createGeneralizedTriple(RDFTerm subject, RDFTerm predicate, RDFTerm object) {
        return internalJenaFactory.createGeneralizedTriple(subject, predicate, object);
    }

    public JenaGeneralizedQuadLike createGeneralizedQuad(RDFTerm subject, RDFTerm predicate, RDFTerm object, RDFTerm graphName) {
        return internalJenaFactory.createGeneralizedQuad(subject, predicate, object, graphName);
    }

    public JenaRDFTerm asRDFTerm(Node node) throws ConversionException {
        return internalJenaFactory.createRDFTerm(node, this.salt());
    }

    public static RDFTerm asRDFTerm(RDF factory, Node node) {
        if (node == null) {
            return null;
        }
        if (factory instanceof JenaRDF) {
            return ((JenaRDF)factory).asRDFTerm(node);
        }
        if (node.isURI()) {
            return factory.createIRI(node.getURI());
        }
        if (node.isLiteral()) {
            String lang = node.getLiteralLanguage();
            if (lang != null && !lang.isEmpty()) {
                return factory.createLiteral(node.getLiteralLexicalForm(), lang);
            }
            if (node.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
                return factory.createLiteral(node.getLiteralLexicalForm());
            }
            IRI dt = factory.createIRI(node.getLiteralDatatype().getURI());
            return factory.createLiteral(node.getLiteralLexicalForm(), dt);
        }
        if (node.isBlank()) {
            return factory.createBlankNode(node.getBlankNodeLabel());
        }
        throw new ConversionException("Node is not a concrete RDF Term: " + node);
    }

    public JenaTriple asTriple(Triple triple) throws ConversionException {
        return internalJenaFactory.createTriple(triple, this.salt());
    }

    public JenaTripleLike asGeneralizedTriple(Triple triple) throws ConversionException {
        return internalJenaFactory.createGeneralizedTriple(triple, this.salt());
    }

    public JenaQuadLike<RDFTerm> asGeneralizedQuad(Quad quad) throws ConversionException {
        return internalJenaFactory.createGeneralizedQuad(quad, this.salt());
    }

    public static org.apache.commons.rdf.api.Triple asTriple(RDF factory, Triple triple) throws ConversionException {
        IRI predicate;
        BlankNodeOrIRI subject;
        if (factory instanceof JenaRDF) {
            return ((JenaRDF)factory).asTriple(triple);
        }
        try {
            subject = (BlankNodeOrIRI)JenaRDF.asRDFTerm(factory, triple.getSubject());
            predicate = (IRI)JenaRDF.asRDFTerm(factory, triple.getPredicate());
        }
        catch (ClassCastException ex) {
            throw new ConversionException("Can't convert generalized triple: " + triple, ex);
        }
        RDFTerm object = JenaRDF.asRDFTerm(factory, triple.getObject());
        return factory.createTriple(subject, predicate, object);
    }

    public JenaQuad asQuad(Quad quad) {
        return internalJenaFactory.createQuad(quad, this.salt());
    }

    public JenaGraph asGraph(org.apache.jena.graph.Graph graph) {
        return internalJenaFactory.createGraph(graph, this.salt());
    }

    public JenaGraph asGraph(Model model) {
        return internalJenaFactory.createGraph(model, this.salt());
    }

    public JenaDataset asDataset(DatasetGraph datasetGraph) {
        return internalJenaFactory.createDataset(datasetGraph, this.salt());
    }

    public JenaDataset asDataset(Dataset datasetGraph) {
        return internalJenaFactory.createDataset(datasetGraph.asDatasetGraph(), this.salt());
    }

    public static org.apache.commons.rdf.api.Quad asQuad(RDF factory, Quad quad) {
        if (factory instanceof JenaRDF) {
            return ((JenaRDF)factory).asQuad(quad);
        }
        BlankNodeOrIRI graphName = (BlankNodeOrIRI)JenaRDF.asRDFTerm(factory, quad.getGraph());
        BlankNodeOrIRI subject = (BlankNodeOrIRI)JenaRDF.asRDFTerm(factory, quad.getSubject());
        IRI predicate = (IRI)JenaRDF.asRDFTerm(factory, quad.getPredicate());
        RDFTerm object = JenaRDF.asRDFTerm(factory, quad.getObject());
        return factory.createQuad(graphName, subject, predicate, object);
    }

    public Optional<RDFSyntax> asRDFSyntax(Lang lang) {
        return RDFSyntax.byMediaType((String)lang.getContentType().getContentType());
    }

    public Optional<Lang> asJenaLang(RDFSyntax rdfSyntax) {
        return Optional.ofNullable(RDFLanguages.contentTypeToLang((String)rdfSyntax.mediaType()));
    }

    public static StreamRDF streamJenaToQuad(final RDF factory, final Consumer<org.apache.commons.rdf.api.Quad> consumer) {
        return new StreamRDFBase(){

            public void quad(Quad quad) {
                consumer.accept(JenaRDF.asQuad(factory, quad));
            }
        };
    }

    public StreamRDF streamJenaToGeneralizedTriple(final Consumer<TripleLike> generalizedConsumer) {
        return new StreamRDFBase(){

            public void triple(Triple triple) {
                generalizedConsumer.accept(JenaRDF.this.asGeneralizedTriple(triple));
            }
        };
    }

    public StreamRDF streamJenaToGeneralizedQuad(final Consumer<QuadLike<RDFTerm>> generalizedConsumer) {
        return new StreamRDFBase(){

            public void quad(Quad quad) {
                generalizedConsumer.accept(JenaRDF.this.asGeneralizedQuad(quad));
            }
        };
    }

    public org.apache.jena.graph.Graph asJenaGraph(Graph graph) {
        if (graph instanceof JenaGraph) {
            return ((JenaGraph)graph).asJenaGraph();
        }
        org.apache.jena.graph.Graph g = GraphFactory.createGraphMem();
        graph.stream().forEach(t -> g.add(this.asJenaTriple((org.apache.commons.rdf.api.Triple)t)));
        return g;
    }

    public Node asJenaNode(RDFTerm term) {
        if (term == null) {
            return null;
        }
        if (term instanceof JenaRDFTerm) {
            return ((JenaRDFTerm)term).asJenaNode();
        }
        if (term instanceof IRI) {
            return NodeFactory.createURI((String)((IRI)term).getIRIString());
        }
        if (term instanceof Literal) {
            Literal lit = (Literal)term;
            RDFDatatype dt = NodeFactory.getType((String)lit.getDatatype().getIRIString());
            String lang = lit.getLanguageTag().orElse("");
            return NodeFactory.createLiteral((String)lit.getLexicalForm(), (String)lang, (RDFDatatype)dt);
        }
        if (term instanceof BlankNode) {
            String id = ((BlankNode)term).uniqueReference();
            return NodeFactory.createBlankNode((String)id);
        }
        throw new ConversionException("Not a concrete RDF Term: " + term);
    }

    public Triple asJenaTriple(org.apache.commons.rdf.api.Triple triple) {
        if (triple instanceof JenaTriple) {
            return ((JenaTriple)triple).asJenaTriple();
        }
        return Triple.create((Node)this.asJenaNode((RDFTerm)triple.getSubject()), (Node)this.asJenaNode((RDFTerm)triple.getPredicate()), (Node)this.asJenaNode(triple.getObject()));
    }

    public Quad asJenaQuad(org.apache.commons.rdf.api.Quad quad) {
        if (quad instanceof JenaQuad) {
            return ((JenaQuad)quad).asJenaQuad();
        }
        return Quad.create((Node)this.asJenaNode(quad.getGraphName().orElse(null)), (Node)this.asJenaNode((RDFTerm)quad.getSubject()), (Node)this.asJenaNode((RDFTerm)quad.getPredicate()), (Node)this.asJenaNode(quad.getObject()));
    }

    private void validateIRI(String iri) {
        if (iri.contains(" ")) {
            throw new IllegalArgumentException();
        }
        if (iri.contains("<")) {
            throw new IllegalArgumentException();
        }
        if (iri.contains(">")) {
            throw new IllegalArgumentException();
        }
    }

    private static void validateLang(String languageTag) {
        if (languageTag.contains(" ")) {
            throw new IllegalArgumentException("Invalid language tag: " + languageTag);
        }
    }

    public UUID salt() {
        return this.salt;
    }
}

