/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.experimental;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.QuadLike;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.TripleLike;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.commons.rdf.simple.experimental.AbstractRDFParser;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class JenaRDFParser
extends AbstractRDFParser<JenaRDFParser> {
    private Consumer<TripleLike> generalizedConsumerTriple;
    private Consumer<QuadLike<RDFTerm>> generalizedConsumerQuad;

    protected RDF createRDFTermFactory() {
        return new JenaRDF();
    }

    public JenaRDFParser targetGeneralizedTriple(Consumer<TripleLike> consumer) {
        JenaRDFParser c = (JenaRDFParser)this.clone();
        c.resetTarget();
        c.generalizedConsumerTriple = consumer;
        return c;
    }

    public JenaRDFParser targetGeneralizedQuad(Consumer<QuadLike<RDFTerm>> consumer) {
        JenaRDFParser c = (JenaRDFParser)this.clone();
        c.resetTarget();
        c.generalizedConsumerQuad = consumer;
        return c;
    }

    protected void resetTarget() {
        super.resetTarget();
        this.generalizedConsumerTriple = null;
        this.generalizedConsumerQuad = null;
    }

    protected void parseSynchronusly() throws IOException {
        StreamRDF dest;
        JenaRDF jenaRDF = this.getJenaFactory();
        if (this.getTargetGraph().isPresent() && this.getTargetGraph().get() instanceof JenaGraph) {
            Graph jenaGraph = ((JenaGraph)this.getTargetGraph().get()).asJenaGraph();
            dest = StreamRDFLib.graph((Graph)jenaGraph);
        } else {
            dest = this.generalizedConsumerQuad != null ? jenaRDF.streamJenaToGeneralizedQuad(this.generalizedConsumerQuad) : (this.generalizedConsumerTriple != null ? jenaRDF.streamJenaToGeneralizedTriple(this.generalizedConsumerTriple) : JenaRDF.streamJenaToQuad((RDF)this.getRdfTermFactory().get(), this.getTarget()));
        }
        Lang lang = this.getContentTypeSyntax().flatMap(jenaRDF::asJenaLang).orElse(null);
        String baseStr = this.getBase().map(IRI::getIRIString).orElse(null);
        if (this.getSourceIri().isPresent()) {
            RDFParser.source((String)((IRI)this.getSourceIri().get()).toString()).base(baseStr).lang(lang).parse(dest);
        } else if (this.getSourceFile().isPresent()) {
            try (InputStream s = Files.newInputStream((Path)this.getSourceFile().get(), new OpenOption[0]);){
                RDFParser.source((InputStream)s).base(baseStr).lang(lang).parse(dest);
            }
        } else {
            RDFParser.source((InputStream)((InputStream)this.getSourceInputStream().get())).base(baseStr).lang(lang).parse(dest);
        }
    }

    private JenaRDF getJenaFactory() {
        return (JenaRDF)this.getRdfTermFactory().filter(JenaRDF.class::isInstance).orElseGet(this::createRDFTermFactory);
    }
}

