/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.jena.JenaQuadLike;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.commons.rdf.jena.JenaRDFTerm;
import org.apache.commons.rdf.jena.impl.InternalJenaFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

abstract class AbstractQuadLike<S extends RDFTerm, P extends RDFTerm, O extends RDFTerm, G extends RDFTerm>
implements JenaQuadLike<G> {
    private static InternalJenaFactory internalJenaFactory = new InternalJenaFactory(){};
    private static DefaultGraphChecker defaultGraphChecker = new DefaultGraphChecker();
    final Optional<G> graphName;
    final S subject;
    final P predicate;
    final O object;
    Quad quad = null;
    Triple triple = null;

    AbstractQuadLike(S subject, P predicate, O object, Optional<G> graphName) {
        this.subject = (RDFTerm)Objects.requireNonNull(subject);
        this.predicate = (RDFTerm)Objects.requireNonNull(predicate);
        this.object = (RDFTerm)Objects.requireNonNull(object);
        this.graphName = Objects.requireNonNull(graphName).filter(defaultGraphChecker::isNotDefaultGraphJenaNode);
    }

    AbstractQuadLike(S subject, P predicate, O object) {
        this(subject, predicate, object, Optional.empty());
    }

    AbstractQuadLike(Quad quad, UUID salt) {
        this.quad = Objects.requireNonNull(quad);
        this.subject = internalJenaFactory.createRDFTerm(quad.getSubject(), salt);
        this.predicate = internalJenaFactory.createRDFTerm(quad.getPredicate(), salt);
        this.object = internalJenaFactory.createRDFTerm(quad.getObject(), salt);
        this.graphName = quad.isDefaultGraph() ? Optional.empty() : Optional.of(internalJenaFactory.createRDFTerm(quad.getGraph(), salt));
    }

    AbstractQuadLike(Triple triple, UUID salt) {
        this.triple = Objects.requireNonNull(triple);
        this.subject = internalJenaFactory.createRDFTerm(triple.getSubject(), salt);
        this.predicate = internalJenaFactory.createRDFTerm(triple.getPredicate(), salt);
        this.object = internalJenaFactory.createRDFTerm(triple.getObject(), salt);
        this.graphName = Optional.empty();
    }

    @Override
    public Quad asJenaQuad() {
        JenaRDF factory = new JenaRDF();
        if (this.quad == null) {
            this.quad = Quad.create((Node)this.graphName.map(factory::asJenaNode).orElse(Quad.defaultGraphIRI), (Node)factory.asJenaNode((RDFTerm)this.subject), (Node)factory.asJenaNode((RDFTerm)this.predicate), (Node)factory.asJenaNode((RDFTerm)this.object));
        }
        return this.quad;
    }

    @Override
    public Triple asJenaTriple() {
        JenaRDF factory = new JenaRDF();
        if (this.triple == null) {
            this.triple = Triple.create((Node)factory.asJenaNode((RDFTerm)this.subject), (Node)factory.asJenaNode((RDFTerm)this.predicate), (Node)factory.asJenaNode((RDFTerm)this.object));
        }
        return this.triple;
    }

    public S getSubject() {
        return this.subject;
    }

    public P getPredicate() {
        return this.predicate;
    }

    public O getObject() {
        return this.object;
    }

    public Optional<G> getGraphName() {
        return this.graphName;
    }

    public String toString() {
        return this.getSubject().ntriplesString() + " " + this.getPredicate().ntriplesString() + " " + this.getObject().ntriplesString() + " " + this.getGraphName().map(RDFTerm::ntriplesString).orElse("") + ".";
    }

    static /* synthetic */ InternalJenaFactory access$000() {
        return internalJenaFactory;
    }

    private static class DefaultGraphChecker {
        private final UUID salt = UUID.fromString("aaa6bf96-ea58-4a55-9485-3733403a1f24");
        private final RDFTerm defaultGraph = AbstractQuadLike.access$000().createRDFTerm(Quad.defaultGraphIRI, this.salt);
        private final RDFTerm defaultGraphNodeGenerated = AbstractQuadLike.access$000().createRDFTerm(Quad.defaultGraphNodeGenerated, this.salt);

        private DefaultGraphChecker() {
        }

        public boolean isNotDefaultGraph(RDFTerm graphName) {
            return !graphName.equals((Object)this.defaultGraph) && !graphName.equals((Object)this.defaultGraphNodeGenerated);
        }

        public boolean isNotDefaultGraphJenaNode(RDFTerm graphName) {
            return !(graphName instanceof JenaRDFTerm) || !Quad.isDefaultGraph((Node)((JenaRDFTerm)graphName).asJenaNode());
        }
    }
}

