/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.util.Optional;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.jena.ConversionException;
import org.apache.commons.rdf.jena.JenaBlankNode;
import org.apache.commons.rdf.jena.JenaDataset;
import org.apache.commons.rdf.jena.JenaGeneralizedQuadLike;
import org.apache.commons.rdf.jena.JenaGeneralizedTripleLike;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaIRI;
import org.apache.commons.rdf.jena.JenaLiteral;
import org.apache.commons.rdf.jena.JenaQuad;
import org.apache.commons.rdf.jena.JenaRDFTerm;
import org.apache.commons.rdf.jena.JenaTriple;
import org.apache.commons.rdf.jena.impl.JenaBlankNodeImpl;
import org.apache.commons.rdf.jena.impl.JenaDatasetImpl;
import org.apache.commons.rdf.jena.impl.JenaGeneralizedQuadLikeImpl;
import org.apache.commons.rdf.jena.impl.JenaGeneralizedTripleLikeImpl;
import org.apache.commons.rdf.jena.impl.JenaGraphImpl;
import org.apache.commons.rdf.jena.impl.JenaIRIImpl;
import org.apache.commons.rdf.jena.impl.JenaLiteralImpl;
import org.apache.commons.rdf.jena.impl.JenaQuadImpl;
import org.apache.commons.rdf.jena.impl.JenaTripleImpl;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.system.JenaSystem;

public abstract class InternalJenaFactory {
    public JenaBlankNode createBlankNode(String id, UUID salt) {
        return new JenaBlankNodeImpl(NodeFactory.createBlankNode((String)id), salt);
    }

    public JenaBlankNode createBlankNode(UUID salt) {
        return new JenaBlankNodeImpl(NodeFactory.createBlankNode(), salt);
    }

    public JenaDataset createDataset(DatasetGraph datasetGraph, UUID salt) {
        return new JenaDatasetImpl(datasetGraph, salt);
    }

    public JenaDataset createDataset(UUID salt) {
        DatasetGraph dg = DatasetGraphFactory.createGeneral();
        return new JenaDatasetImpl(dg, salt);
    }

    public JenaGeneralizedQuadLike createGeneralizedQuad(Quad quad, UUID salt) {
        return new JenaGeneralizedQuadLikeImpl(quad, salt);
    }

    public JenaGeneralizedQuadLike createGeneralizedQuad(RDFTerm subject, RDFTerm predicate, RDFTerm object, RDFTerm graphName) {
        return new JenaGeneralizedQuadLikeImpl(subject, predicate, object, Optional.ofNullable(graphName));
    }

    public JenaGeneralizedTripleLike createGeneralizedTriple(Triple triple, UUID salt) {
        return new JenaGeneralizedTripleLikeImpl(triple, salt);
    }

    public JenaGeneralizedTripleLike createGeneralizedTriple(RDFTerm subject, RDFTerm predicate, RDFTerm object) {
        return new JenaGeneralizedTripleLikeImpl(subject, predicate, object);
    }

    public JenaGraph createGraph(Model model, UUID salt) {
        return new JenaGraphImpl(model, salt);
    }

    public JenaGraph createGraph(Graph graph, UUID salt) {
        return new JenaGraphImpl(graph, salt);
    }

    public JenaGraph createGraph(UUID salt) {
        return new JenaGraphImpl(GraphFactory.createDefaultGraph(), salt);
    }

    public JenaIRI createIRI(String iriStr) {
        return new JenaIRIImpl(iriStr);
    }

    public JenaLiteral createLiteral(String lexStr) {
        return new JenaLiteralImpl(NodeFactory.createLiteral((String)lexStr));
    }

    public JenaLiteral createLiteralDT(String lexStr, String datatypeIRI) {
        return new JenaLiteralImpl(NodeFactory.createLiteral((String)lexStr, (RDFDatatype)NodeFactory.getType((String)datatypeIRI)));
    }

    public JenaLiteral createLiteralLang(String lexStr, String langTag) {
        return new JenaLiteralImpl(NodeFactory.createLiteral((String)lexStr, (String)langTag));
    }

    public JenaQuad createQuad(BlankNodeOrIRI subject, IRI predicate, RDFTerm object, BlankNodeOrIRI graphName) {
        return new JenaQuadImpl(subject, predicate, object, Optional.ofNullable(graphName));
    }

    public JenaQuad createQuad(Quad quad, UUID salt) {
        return new JenaQuadImpl(quad, salt);
    }

    public JenaRDFTerm createRDFTerm(Node node, UUID salt) throws ConversionException {
        if (!node.isConcrete()) {
            throw new ConversionException("Node is not a concrete RDF Term: " + node);
        }
        if (node.isURI()) {
            return new JenaIRIImpl(node);
        }
        if (node.isLiteral()) {
            return new JenaLiteralImpl(node);
        }
        if (node.isBlank()) {
            return new JenaBlankNodeImpl(node, salt);
        }
        if (node.equals((Object)Node.ANY)) {
            // empty if block
        }
        if (node.isVariable()) {
            // empty if block
        }
        throw new ConversionException("Unrecognized node type: " + node);
    }

    public JenaTriple createTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return new JenaTripleImpl(subject, predicate, object);
    }

    public JenaTriple createTriple(Triple triple, UUID salt) {
        return new JenaTripleImpl(triple, salt);
    }

    static {
        JenaSystem.init();
    }
}

