/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.util.UUID;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.jena.JenaBlankNode;
import org.apache.commons.rdf.jena.impl.AbstractJenaRDFTerm;
import org.apache.jena.graph.Node;

class JenaBlankNodeImpl
extends AbstractJenaRDFTerm
implements JenaBlankNode {
    private final UUID salt;

    JenaBlankNodeImpl(Node node, UUID salt) {
        super(node);
        if (!node.isBlank()) {
            throw new IllegalArgumentException("Node is not a blank node: " + node);
        }
        this.salt = salt;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof BlankNode)) {
            return false;
        }
        BlankNode bNode = (BlankNode)other;
        return this.uniqueReference().equals(bNode.uniqueReference());
    }

    public int hashCode() {
        return this.uniqueReference().hashCode();
    }

    public String uniqueReference() {
        return this.salt + this.asJenaNode().getBlankNodeLabel();
    }
}

