/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.jena.JenaDataset;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.commons.rdf.jena.impl.JenaGraphImpl;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;

class JenaDatasetImpl
implements JenaDataset {
    private final DatasetGraph datasetGraph;
    private final UUID salt;
    private final JenaRDF factory;

    JenaDatasetImpl(DatasetGraph datasetGraph, UUID salt) {
        this.datasetGraph = datasetGraph;
        this.salt = salt;
        this.factory = new JenaRDF(salt);
    }

    public void add(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.datasetGraph.add(org.apache.jena.sparql.core.Quad.create((Node)this.factory.asJenaNode((RDFTerm)graphName), (Node)this.factory.asJenaNode((RDFTerm)subject), (Node)this.factory.asJenaNode((RDFTerm)predicate), (Node)this.factory.asJenaNode(object)));
    }

    public void add(Quad quad) {
        this.datasetGraph.add(this.factory.asJenaQuad(quad));
    }

    @Override
    public DatasetGraph asJenaDatasetGraph() {
        return this.datasetGraph;
    }

    public void clear() {
        this.datasetGraph.clear();
    }

    public void close() {
        this.datasetGraph.close();
    }

    public boolean contains(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.datasetGraph.contains(this.toJenaPattern(graphName), this.toJenaPattern((RDFTerm)subject), this.toJenaPattern((RDFTerm)predicate), this.toJenaPattern(object));
    }

    private Node toJenaPattern(Optional<? extends RDFTerm> graphName) {
        if (graphName == null) {
            return Node.ANY;
        }
        return this.factory.asJenaNode(graphName.orElse(null));
    }

    private Node toJenaPattern(RDFTerm term) {
        if (term == null) {
            return Node.ANY;
        }
        return this.factory.asJenaNode(term);
    }

    public boolean contains(Quad quad) {
        return this.datasetGraph.contains(this.factory.asJenaQuad(quad));
    }

    public void remove(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.datasetGraph.deleteAny(this.toJenaPattern(graphName), this.toJenaPattern((RDFTerm)subject), this.toJenaPattern((RDFTerm)predicate), this.toJenaPattern(object));
    }

    public void remove(Quad quad) {
        this.datasetGraph.deleteAny(this.toJenaPattern(quad.getGraphName()), this.toJenaPattern((RDFTerm)quad.getSubject()), this.toJenaPattern((RDFTerm)quad.getPredicate()), this.toJenaPattern(quad.getObject()));
    }

    public long size() {
        long quads = Iter.asStream((Iterator)this.datasetGraph.listGraphNodes()).map(arg_0 -> ((DatasetGraph)this.datasetGraph).getGraph(arg_0)).collect(Collectors.summingLong(Graph::size));
        return quads + (long)this.datasetGraph.getDefaultGraph().size();
    }

    public Stream<? extends Quad> stream() {
        JenaRDF factory = new JenaRDF(this.salt);
        return Iter.asStream((Iterator)this.datasetGraph.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY), (boolean)true).map(factory::asQuad);
    }

    public Stream<? extends Quad> stream(Optional<BlankNodeOrIRI> g, BlankNodeOrIRI s, IRI p, RDFTerm o) {
        JenaRDF factory = new JenaRDF(this.salt);
        return Iter.asStream((Iterator)this.datasetGraph.find(this.toJenaPattern(g), this.toJenaPattern((RDFTerm)s), this.toJenaPattern((RDFTerm)p), this.toJenaPattern(o)), (boolean)true).map(factory::asQuad);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (DatasetGraph)this.datasetGraph, (Lang)Lang.NQUADS);
        return sw.toString();
    }

    public org.apache.commons.rdf.api.Graph getGraph() {
        GraphView g = GraphView.createDefaultGraph((DatasetGraph)this.datasetGraph);
        return new JenaGraphImpl((Graph)g, this.salt);
    }

    @Override
    public JenaGraph getUnionGraph() {
        GraphView gv = GraphView.createUnionGraph((DatasetGraph)this.datasetGraph);
        return new JenaGraphImpl((Graph)gv, this.salt);
    }

    public Optional<org.apache.commons.rdf.api.Graph> getGraph(BlankNodeOrIRI graphName) {
        GraphView gv = GraphView.createNamedGraph((DatasetGraph)this.datasetGraph, (Node)this.factory.asJenaNode((RDFTerm)graphName));
        return Optional.of(new JenaGraphImpl((Graph)gv, this.salt));
    }

    public Stream<BlankNodeOrIRI> getGraphNames() {
        JenaRDF factory = new JenaRDF(this.salt);
        return Iter.asStream((Iterator)this.datasetGraph.listGraphNodes()).map(node -> (BlankNodeOrIRI)factory.asRDFTerm((Node)node));
    }

    public Iterable<Quad> iterate() {
        JenaRDF factory = new JenaRDF(this.salt);
        return Iter.asStream((Iterator)this.datasetGraph.find(), (boolean)false).map(q -> factory.asQuad((org.apache.jena.sparql.core.Quad)q))::iterator;
    }
}

