/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.jena.JenaGraph;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

class JenaGraphImpl
implements JenaGraph {
    private final Graph graph;
    private final UUID salt;
    private final transient JenaRDF factory;
    private Model model;

    JenaGraphImpl(Graph graph, UUID salt) {
        this.graph = graph;
        this.salt = salt;
        this.factory = new JenaRDF(salt);
    }

    JenaGraphImpl(Model model, UUID salt) {
        this.model = model;
        this.graph = model.getGraph();
        this.salt = salt;
        this.factory = new JenaRDF(salt);
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.graph.add(org.apache.jena.graph.Triple.create((Node)this.factory.asJenaNode((RDFTerm)subject), (Node)this.factory.asJenaNode((RDFTerm)predicate), (Node)this.factory.asJenaNode(object)));
    }

    public void add(Triple triple) {
        this.graph.add(this.factory.asJenaTriple(triple));
    }

    @Override
    public Graph asJenaGraph() {
        return this.graph;
    }

    public void clear() {
        this.graph.clear();
    }

    public void close() {
        this.graph.close();
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.graph.contains(this.toJenaPattern((RDFTerm)subject), this.toJenaPattern((RDFTerm)predicate), this.toJenaPattern(object));
    }

    public boolean contains(Triple triple) {
        return this.graph.contains(this.factory.asJenaTriple(triple));
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.graph.remove(this.toJenaPattern((RDFTerm)subject), this.toJenaPattern((RDFTerm)predicate), this.toJenaPattern(object));
    }

    private Node toJenaPattern(RDFTerm pattern) {
        if (pattern == null) {
            return Node.ANY;
        }
        return this.factory.asJenaNode(pattern);
    }

    public void remove(Triple triple) {
        if (triple.getObject() instanceof Literal && ((Literal)triple.getObject()).getLanguageTag().isPresent()) {
            this.graph.remove(this.factory.asJenaNode((RDFTerm)triple.getSubject()), this.factory.asJenaNode((RDFTerm)triple.getPredicate()), this.factory.asJenaNode(triple.getObject()));
        } else {
            this.graph.delete(this.factory.asJenaTriple(triple));
        }
    }

    public long size() {
        return this.graph.size();
    }

    public Stream<? extends Triple> stream() {
        JenaRDF factory = new JenaRDF(this.salt);
        return Iter.asStream((Iterator)this.graph.find(null, null, null), (boolean)true).map(factory::asTriple);
    }

    public Stream<? extends Triple> stream(BlankNodeOrIRI s, IRI p, RDFTerm o) {
        JenaRDF factory = new JenaRDF(this.salt);
        return Iter.asStream((Iterator)this.graph.find(this.toJenaAny((RDFTerm)s), this.toJenaAny((RDFTerm)p), this.toJenaAny(o)), (boolean)true).map(factory::asTriple);
    }

    private Node toJenaAny(RDFTerm term) {
        if (term == null) {
            return Node.ANY;
        }
        return this.factory.asJenaNode(term);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Graph)this.graph, (Lang)Lang.NT);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model asJenaModel() {
        if (this.model == null) {
            JenaGraphImpl jenaGraphImpl = this;
            synchronized (jenaGraphImpl) {
                if (this.model == null) {
                    this.model = ModelFactory.createModelForGraph((Graph)this.graph);
                }
            }
        }
        return this.model;
    }
}

