/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.jena.JenaIRI;
import org.apache.commons.rdf.jena.impl.AbstractJenaRDFTerm;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

class JenaIRIImpl
extends AbstractJenaRDFTerm
implements JenaIRI {
    JenaIRIImpl(Node node) {
        super(node);
        if (!node.isURI()) {
            throw new IllegalArgumentException("Node is not an IRI node: " + node);
        }
    }

    JenaIRIImpl(String iriStr) {
        super(NodeFactory.createURI((String)iriStr));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof IRI)) {
            return false;
        }
        IRI iri = (IRI)other;
        return this.getIRIString().equals(iri.getIRIString());
    }

    public String getIRIString() {
        return this.asJenaNode().getURI();
    }

    public int hashCode() {
        return this.getIRIString().hashCode();
    }
}

