/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.jena.JenaLiteral;
import org.apache.commons.rdf.jena.impl.AbstractJenaRDFTerm;
import org.apache.commons.rdf.jena.impl.InternalJenaFactory;
import org.apache.jena.graph.Node;

class JenaLiteralImpl
extends AbstractJenaRDFTerm
implements JenaLiteral {
    private static InternalJenaFactory internalJenaFactory = new InternalJenaFactory(){};

    JenaLiteralImpl(Node node) {
        super(node);
        if (!node.isLiteral()) {
            throw new IllegalArgumentException("Node is not a literal: " + node);
        }
    }

    private static String lowerCase(String langTag) {
        return langTag.toLowerCase(Locale.ROOT);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Literal)) {
            return false;
        }
        Literal literal = (Literal)other;
        return this.getLexicalForm().equals(literal.getLexicalForm()) && this.getDatatype().equals((Object)literal.getDatatype()) && this.getLanguageTag().map(JenaLiteralImpl::lowerCase).equals(literal.getLanguageTag().map(JenaLiteralImpl::lowerCase));
    }

    public IRI getDatatype() {
        return internalJenaFactory.createIRI(this.asJenaNode().getLiteralDatatype().getURI());
    }

    public Optional<String> getLanguageTag() {
        String x = this.asJenaNode().getLiteralLanguage();
        if (x == null || x.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(x);
    }

    public String getLexicalForm() {
        return this.asJenaNode().getLiteralLexicalForm();
    }

    public int hashCode() {
        return Objects.hash(this.getLexicalForm(), this.getDatatype(), this.getLanguageTag().map(JenaLiteralImpl::lowerCase));
    }
}

