/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.jena.ConversionException;
import org.apache.commons.rdf.jena.JenaQuad;
import org.apache.commons.rdf.jena.impl.AbstractQuadLike;

class JenaQuadImpl
extends AbstractQuadLike<BlankNodeOrIRI, IRI, RDFTerm, BlankNodeOrIRI>
implements JenaQuad {
    JenaQuadImpl(BlankNodeOrIRI subject, IRI predicate, RDFTerm object, Optional<BlankNodeOrIRI> graphName) {
        super(subject, predicate, object, graphName);
    }

    JenaQuadImpl(org.apache.jena.sparql.core.Quad quad, UUID salt) {
        super(quad, salt);
        if (this.graphName.isPresent() && !(this.graphName.get() instanceof BlankNodeOrIRI) || !(this.subject instanceof BlankNodeOrIRI) || !(this.predicate instanceof IRI) || !(this.object instanceof RDFTerm)) {
            throw new ConversionException("Can't adapt generalized quad: " + quad);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)other;
        return this.getGraphName().equals(quad.getGraphName()) && ((BlankNodeOrIRI)this.getSubject()).equals(quad.getSubject()) && ((IRI)this.getPredicate()).equals((Object)quad.getPredicate()) && this.getObject().equals((Object)quad.getObject());
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject(), this.getGraphName());
    }
}

