/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.jena.impl;

import java.util.Objects;
import java.util.UUID;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.jena.ConversionException;
import org.apache.commons.rdf.jena.JenaTriple;
import org.apache.commons.rdf.jena.impl.AbstractQuadLike;

class JenaTripleImpl
extends AbstractQuadLike<BlankNodeOrIRI, IRI, RDFTerm, RDFTerm>
implements JenaTriple {
    JenaTripleImpl(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        super(subject, predicate, object);
    }

    JenaTripleImpl(org.apache.jena.graph.Triple triple, UUID salt) throws ConversionException {
        super(triple, salt);
        if (!(this.subject instanceof BlankNodeOrIRI && this.predicate instanceof IRI && this.object instanceof RDFTerm)) {
            throw new ConversionException("Can't adapt generalized triple: " + this.quad);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)other;
        return ((BlankNodeOrIRI)this.getSubject()).equals(triple.getSubject()) && ((IRI)this.getPredicate()).equals((Object)triple.getPredicate()) && this.getObject().equals((Object)triple.getObject());
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject());
    }
}

