/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateSampler;
import org.apache.commons.rng.sampling.distribution.GuideTableDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class DiscreteProbabilityCollectionSampler<T>
implements SharedStateSampler<DiscreteProbabilityCollectionSampler<T>> {
    private static final String EMPTY_COLLECTION = "Empty collection";
    private final List<T> items;
    private final SharedStateDiscreteSampler sampler;

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, Map<T, Double> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(EMPTY_COLLECTION);
        }
        int size = collection.size();
        this.items = new ArrayList<T>(size);
        double[] probabilities = new double[size];
        int count = 0;
        for (Map.Entry<T, Double> e : collection.entrySet()) {
            this.items.add(e.getKey());
            probabilities[count++] = e.getValue();
        }
        this.sampler = DiscreteProbabilityCollectionSampler.createSampler(rng, probabilities);
    }

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, List<T> collection, double[] probabilities) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(EMPTY_COLLECTION);
        }
        int len = probabilities.length;
        if (len != collection.size()) {
            throw new IllegalArgumentException("Size mismatch: " + len + " != " + collection.size());
        }
        this.items = new ArrayList<T>(collection);
        this.sampler = DiscreteProbabilityCollectionSampler.createSampler(rng, probabilities);
    }

    private DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, DiscreteProbabilityCollectionSampler<T> source) {
        this.items = source.items;
        this.sampler = (SharedStateDiscreteSampler)source.sampler.withUniformRandomProvider(rng);
    }

    public T sample() {
        return this.items.get(this.sampler.sample());
    }

    @Override
    public DiscreteProbabilityCollectionSampler<T> withUniformRandomProvider(UniformRandomProvider rng) {
        return new DiscreteProbabilityCollectionSampler<T>(rng, this);
    }

    private static SharedStateDiscreteSampler createSampler(UniformRandomProvider rng, double[] probabilities) {
        return GuideTableDiscreteSampler.of(rng, probabilities);
    }
}

