/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateSampler;
import org.apache.commons.rng.sampling.distribution.InternalGamma;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

final class InternalUtils {
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private static final int BEGIN_LOG_FACTORIALS = 2;
    private static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;

    private InternalUtils() {
    }

    static long factorial(int n) {
        return FACTORIALS[n];
    }

    static double validateProbabilities(double[] probabilities) {
        if (probabilities == null || probabilities.length == 0) {
            throw new IllegalArgumentException("Probabilities must not be empty.");
        }
        double sumProb = 0.0;
        for (double prob : probabilities) {
            InternalUtils.validateProbability(prob);
            sumProb += prob;
        }
        if (Double.isInfinite(sumProb) || sumProb <= 0.0) {
            throw new IllegalArgumentException("Invalid sum of probabilities: " + sumProb);
        }
        return sumProb;
    }

    static void validateProbability(double probability) {
        if (probability < 0.0 || Double.isInfinite(probability) || Double.isNaN(probability)) {
            throw new IllegalArgumentException("Invalid probability: " + probability);
        }
    }

    static NormalizedGaussianSampler newNormalizedGaussianSampler(NormalizedGaussianSampler sampler, UniformRandomProvider rng) {
        if (!(sampler instanceof SharedStateSampler)) {
            throw new UnsupportedOperationException("The underlying sampler cannot share state");
        }
        Object newSampler = ((SharedStateSampler)((Object)sampler)).withUniformRandomProvider(rng);
        if (!(newSampler instanceof NormalizedGaussianSampler)) {
            throw new UnsupportedOperationException("The underlying sampler did not create a normalized Gaussian sampler");
        }
        return (NormalizedGaussianSampler)newSampler;
    }

    static double makeNonZeroDouble(long v) {
        return (double)((v >>> 11) + 1L) * (double)1.110223E-16f;
    }

    public static final class FactorialLog {
        private final double[] logFactorials;

        private FactorialLog(int numValues, double[] cache) {
            int endCopy;
            this.logFactorials = new double[numValues];
            if (cache != null && cache.length > 2) {
                endCopy = Math.min(cache.length, numValues);
                System.arraycopy(cache, 2, this.logFactorials, 2, endCopy - 2);
            } else {
                endCopy = 2;
            }
            for (int i = endCopy; i < numValues; ++i) {
                this.logFactorials[i] = i < FACTORIALS.length ? Math.log(FACTORIALS[i]) : this.logFactorials[i - 1] + Math.log(i);
            }
        }

        public static FactorialLog create() {
            return new FactorialLog(0, null);
        }

        public FactorialLog withCache(int cacheSize) {
            return new FactorialLog(cacheSize, this.logFactorials);
        }

        public double value(int n) {
            if (n < this.logFactorials.length) {
                return this.logFactorials[n];
            }
            if (n < FACTORIALS.length) {
                return Math.log(FACTORIALS[n]);
            }
            return InternalGamma.logGamma((double)n + 1.0);
        }
    }
}

