/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public final class GuideTableDiscreteSampler
implements SharedStateDiscreteSampler {
    private static final double DEFAULT_ALPHA = 1.0;
    private final UniformRandomProvider rng;
    private final double[] cumulativeProbabilities;
    private final int[] guideTable;

    private GuideTableDiscreteSampler(UniformRandomProvider rng, double[] cumulativeProbabilities, int[] guideTable) {
        this.rng = rng;
        this.cumulativeProbabilities = cumulativeProbabilities;
        this.guideTable = guideTable;
    }

    @Override
    public int sample() {
        int x;
        double u = this.rng.nextDouble();
        for (x = this.guideTable[GuideTableDiscreteSampler.getGuideTableIndex(u, this.guideTable.length)]; x != 0 && u <= this.cumulativeProbabilities[x - 1]; --x) {
        }
        return x;
    }

    public String toString() {
        return "Guide table deviate [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new GuideTableDiscreteSampler(rng, this.cumulativeProbabilities, this.guideTable);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double[] probabilities) {
        return GuideTableDiscreteSampler.of(rng, probabilities, 1.0);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, double[] probabilities, double alpha) {
        GuideTableDiscreteSampler.validateParameters(probabilities, alpha);
        int size = probabilities.length;
        double[] cumulativeProbabilities = new double[size];
        double sumProb = 0.0;
        int count = 0;
        for (double prob : probabilities) {
            cumulativeProbabilities[count++] = sumProb += InternalUtils.requirePositiveFinite(prob, "probability");
        }
        InternalUtils.requireStrictlyPositiveFinite(sumProb, "sum of probabilities");
        int guideTableSize = (int)Math.ceil(alpha * (double)size);
        int[] guideTable = new int[Math.max(guideTableSize, guideTableSize + 1)];
        for (int x = 0; x < size; ++x) {
            double norm = cumulativeProbabilities[x] / sumProb;
            cumulativeProbabilities[x] = norm < 1.0 ? norm : 1.0;
            int index = GuideTableDiscreteSampler.getGuideTableIndex(cumulativeProbabilities[x], guideTable.length);
            guideTable[index] = x + 1;
        }
        cumulativeProbabilities[size - 1] = 1.0;
        guideTable[guideTable.length - 1] = size;
        for (int i = 1; i < guideTable.length; ++i) {
            guideTable[i] = Math.max(guideTable[i - 1], guideTable[i]);
        }
        return new GuideTableDiscreteSampler(rng, cumulativeProbabilities, guideTable);
    }

    private static void validateParameters(double[] probabilities, double alpha) {
        if (probabilities == null || probabilities.length == 0) {
            throw new IllegalArgumentException("Probabilities must not be empty.");
        }
        InternalUtils.requireStrictlyPositive(alpha, "alpha");
    }

    private static int getGuideTableIndex(double p, int tableLength) {
        return (int)(p * (double)(tableLength - 1));
    }
}

