/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;
import org.apache.commons.rng.simple.RandomSource;

public final class JDKRandomBridge
extends Random {
    private static final long serialVersionUID = 20161107L;
    private final RandomSource source;
    private transient RestorableUniformRandomProvider delegate;
    private final transient boolean isInitialized;

    public JDKRandomBridge(RandomSource source, Object seed) {
        this.source = source;
        this.delegate = RandomSource.create(source, seed, new Object[0]);
        this.isInitialized = true;
    }

    @Override
    public synchronized void setSeed(long seed) {
        if (this.isInitialized) {
            this.delegate = RandomSource.create(this.source, seed, new Object[0]);
            super.setSeed(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int next(int n) {
        JDKRandomBridge jDKRandomBridge = this;
        synchronized (jDKRandomBridge) {
            return this.delegate.nextInt() >>> 32 - n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream output) throws IOException {
        JDKRandomBridge jDKRandomBridge = this;
        synchronized (jDKRandomBridge) {
            output.defaultWriteObject();
            byte[] state = ((RandomProviderDefaultState)this.delegate.saveState()).getState();
            int size = state.length;
            output.writeInt(size);
            output.write(state);
        }
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.delegate = RandomSource.create(this.source);
        int size = input.readInt();
        byte[] state = new byte[size];
        input.readFully(state);
        this.delegate.restoreState((RandomProviderState)new RandomProviderDefaultState(state));
    }
}

