/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.DotyHumphreySmallFastCounting32;
import org.apache.commons.rng.core.source32.ISAACRandom;
import org.apache.commons.rng.core.source32.JDKRandom;
import org.apache.commons.rng.core.source32.JenkinsSmallFast32;
import org.apache.commons.rng.core.source32.KISSRandom;
import org.apache.commons.rng.core.source32.MersenneTwister;
import org.apache.commons.rng.core.source32.MiddleSquareWeylSequence;
import org.apache.commons.rng.core.source32.MultiplyWithCarry256;
import org.apache.commons.rng.core.source32.PcgMcgXshRr32;
import org.apache.commons.rng.core.source32.PcgMcgXshRs32;
import org.apache.commons.rng.core.source32.PcgXshRr32;
import org.apache.commons.rng.core.source32.PcgXshRs32;
import org.apache.commons.rng.core.source32.Well1024a;
import org.apache.commons.rng.core.source32.Well19937a;
import org.apache.commons.rng.core.source32.Well19937c;
import org.apache.commons.rng.core.source32.Well44497a;
import org.apache.commons.rng.core.source32.Well44497b;
import org.apache.commons.rng.core.source32.Well512a;
import org.apache.commons.rng.core.source32.XoRoShiRo64Star;
import org.apache.commons.rng.core.source32.XoRoShiRo64StarStar;
import org.apache.commons.rng.core.source32.XoShiRo128Plus;
import org.apache.commons.rng.core.source32.XoShiRo128PlusPlus;
import org.apache.commons.rng.core.source32.XoShiRo128StarStar;
import org.apache.commons.rng.core.source64.DotyHumphreySmallFastCounting64;
import org.apache.commons.rng.core.source64.JenkinsSmallFast64;
import org.apache.commons.rng.core.source64.MersenneTwister64;
import org.apache.commons.rng.core.source64.PcgRxsMXs64;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.source64.TwoCmres;
import org.apache.commons.rng.core.source64.XoRoShiRo1024PlusPlus;
import org.apache.commons.rng.core.source64.XoRoShiRo1024Star;
import org.apache.commons.rng.core.source64.XoRoShiRo1024StarStar;
import org.apache.commons.rng.core.source64.XoRoShiRo128Plus;
import org.apache.commons.rng.core.source64.XoRoShiRo128PlusPlus;
import org.apache.commons.rng.core.source64.XoRoShiRo128StarStar;
import org.apache.commons.rng.core.source64.XoShiRo256Plus;
import org.apache.commons.rng.core.source64.XoShiRo256PlusPlus;
import org.apache.commons.rng.core.source64.XoShiRo256StarStar;
import org.apache.commons.rng.core.source64.XoShiRo512Plus;
import org.apache.commons.rng.core.source64.XoShiRo512PlusPlus;
import org.apache.commons.rng.core.source64.XoShiRo512StarStar;
import org.apache.commons.rng.core.source64.XorShift1024Star;
import org.apache.commons.rng.core.source64.XorShift1024StarPhi;
import org.apache.commons.rng.simple.internal.NativeSeedType;
import org.apache.commons.rng.simple.internal.SeedFactory;
import org.apache.commons.rng.simple.internal.SeedUtils;

public final class ProviderBuilder {
    private static final String INTERNAL_ERROR_MSG = "Internal error: Please file a bug report";

    private ProviderBuilder() {
    }

    public static RestorableUniformRandomProvider create(RandomSourceInternal source) {
        return source.create();
    }

    public static RestorableUniformRandomProvider create(RandomSourceInternal source, Object seed, Object[] args) {
        if (args != null) {
            return source.create(seed, args);
        }
        return seed == null ? source.create() : source.create(seed);
    }

    public static enum RandomSourceInternal {
        JDK(JDKRandom.class, 1, NativeSeedType.LONG, new Class[0]),
        WELL_512_A(Well512a.class, 16, NativeSeedType.INT_ARRAY, new Class[0]),
        WELL_1024_A(Well1024a.class, 32, NativeSeedType.INT_ARRAY, new Class[0]),
        WELL_19937_A(Well19937a.class, 624, NativeSeedType.INT_ARRAY, new Class[0]),
        WELL_19937_C(Well19937c.class, 624, NativeSeedType.INT_ARRAY, new Class[0]),
        WELL_44497_A(Well44497a.class, 1391, NativeSeedType.INT_ARRAY, new Class[0]),
        WELL_44497_B(Well44497b.class, 1391, NativeSeedType.INT_ARRAY, new Class[0]),
        MT(MersenneTwister.class, 624, NativeSeedType.INT_ARRAY, new Class[0]),
        ISAAC(ISAACRandom.class, 256, NativeSeedType.INT_ARRAY, new Class[0]),
        SPLIT_MIX_64(SplitMix64.class, 1, NativeSeedType.LONG, new Class[0]),
        XOR_SHIFT_1024_S(XorShift1024Star.class, 16, NativeSeedType.LONG_ARRAY, new Class[0]),
        TWO_CMRES(TwoCmres.class, 1, NativeSeedType.INT, new Class[0]),
        TWO_CMRES_SELECT(TwoCmres.class, 1, NativeSeedType.INT, Integer.TYPE, Integer.TYPE),
        MT_64(MersenneTwister64.class, 312, NativeSeedType.LONG_ARRAY, new Class[0]),
        MWC_256(MultiplyWithCarry256.class, 257, NativeSeedType.INT_ARRAY, new Class[0]),
        KISS(KISSRandom.class, 4, NativeSeedType.INT_ARRAY, new Class[0]),
        XOR_SHIFT_1024_S_PHI(XorShift1024StarPhi.class, 16, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_RO_SHI_RO_64_S(XoRoShiRo64Star.class, 2, NativeSeedType.INT_ARRAY, new Class[0]),
        XO_RO_SHI_RO_64_SS(XoRoShiRo64StarStar.class, 2, NativeSeedType.INT_ARRAY, new Class[0]),
        XO_SHI_RO_128_PLUS(XoShiRo128Plus.class, 4, NativeSeedType.INT_ARRAY, new Class[0]),
        XO_SHI_RO_128_SS(XoShiRo128StarStar.class, 4, NativeSeedType.INT_ARRAY, new Class[0]),
        XO_RO_SHI_RO_128_PLUS(XoRoShiRo128Plus.class, 2, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_RO_SHI_RO_128_SS(XoRoShiRo128StarStar.class, 2, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_SHI_RO_256_PLUS(XoShiRo256Plus.class, 4, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_SHI_RO_256_SS(XoShiRo256StarStar.class, 4, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_SHI_RO_512_PLUS(XoShiRo512Plus.class, 8, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_SHI_RO_512_SS(XoShiRo512StarStar.class, 8, NativeSeedType.LONG_ARRAY, new Class[0]),
        PCG_XSH_RR_32(PcgXshRr32.class, 2, NativeSeedType.LONG_ARRAY, new Class[0]),
        PCG_XSH_RS_32(PcgXshRs32.class, 2, NativeSeedType.LONG_ARRAY, new Class[0]),
        PCG_RXS_M_XS_64(PcgRxsMXs64.class, 2, NativeSeedType.LONG_ARRAY, new Class[0]),
        PCG_MCG_XSH_RR_32(PcgMcgXshRr32.class, 1, NativeSeedType.LONG, new Class[0]),
        PCG_MCG_XSH_RS_32(PcgMcgXshRs32.class, 1, NativeSeedType.LONG, new Class[0]),
        MSWS((Class)MiddleSquareWeylSequence.class, 3, NativeSeedType.LONG_ARRAY, new Class[0]){

            @Override
            protected Object createSeed() {
                return this.createMswsSeed(SeedFactory.createLong());
            }

            @Override
            protected Object convertSeed(Object seed) {
                if (seed instanceof Integer) {
                    return this.createMswsSeed(((Integer)seed).intValue());
                }
                if (seed instanceof Long) {
                    return this.createMswsSeed((Long)seed);
                }
                return super.convertSeed(seed);
            }

            @Override
            protected byte[] createByteArraySeed(UniformRandomProvider source) {
                return NativeSeedType.convertSeedToBytes(this.createMswsSeed(source));
            }

            private long[] createMswsSeed(long seed) {
                return this.createMswsSeed((UniformRandomProvider)new SplitMix64(seed));
            }

            private long[] createMswsSeed(UniformRandomProvider source) {
                long increment;
                long state = increment = SeedUtils.createLongHexPermutation(source);
                long weylState = source.nextLong();
                return new long[]{state, weylState, increment};
            }
        }
        ,
        SFC_32(DotyHumphreySmallFastCounting32.class, 3, NativeSeedType.INT_ARRAY, new Class[0]),
        SFC_64(DotyHumphreySmallFastCounting64.class, 3, NativeSeedType.LONG_ARRAY, new Class[0]),
        JSF_32(JenkinsSmallFast32.class, 1, NativeSeedType.INT, new Class[0]),
        JSF_64(JenkinsSmallFast64.class, 1, NativeSeedType.LONG, new Class[0]),
        XO_SHI_RO_128_PP(XoShiRo128PlusPlus.class, 4, NativeSeedType.INT_ARRAY, new Class[0]),
        XO_RO_SHI_RO_128_PP(XoRoShiRo128PlusPlus.class, 2, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_SHI_RO_256_PP(XoShiRo256PlusPlus.class, 4, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_SHI_RO_512_PP(XoShiRo512PlusPlus.class, 8, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_RO_SHI_RO_1024_PP(XoRoShiRo1024PlusPlus.class, 16, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_RO_SHI_RO_1024_S(XoRoShiRo1024Star.class, 16, NativeSeedType.LONG_ARRAY, new Class[0]),
        XO_RO_SHI_RO_1024_SS(XoRoShiRo1024StarStar.class, 16, NativeSeedType.LONG_ARRAY, new Class[0]);

        private final Class<? extends UniformRandomProvider> rng;
        private final int nativeSeedSize;
        private final Class<?>[] args;
        private final NativeSeedType nativeSeedType;
        private Constructor<?> rngConstructor;

        private RandomSourceInternal(Class<? extends UniformRandomProvider> rng, int nativeSeedSize, NativeSeedType nativeSeedType, Class<?> ... args) {
            this.rng = rng;
            this.nativeSeedSize = nativeSeedSize;
            this.nativeSeedType = nativeSeedType;
            this.args = (Class[])Array.newInstance(args.getClass().getComponentType(), 1 + args.length);
            this.args[0] = nativeSeedType.getType();
            System.arraycopy(args, 0, this.args, 1, args.length);
        }

        public Class<?> getRng() {
            return this.rng;
        }

        Class<?> getSeed() {
            return this.args[0];
        }

        Class<?>[] getArgs() {
            return this.args;
        }

        public <SEED> boolean isNativeSeed(SEED seed) {
            return seed != null && this.getSeed().equals(seed.getClass());
        }

        private int getSeedByteSize() {
            return this.nativeSeedSize * this.nativeSeedType.getBytes();
        }

        RestorableUniformRandomProvider create() {
            Object nativeSeed = this.createSeed();
            return RandomSourceInternal.create(this.getConstructor(), new Object[]{nativeSeed});
        }

        RestorableUniformRandomProvider create(Object seed) {
            Object nativeSeed = this.convertSeed(seed);
            return RandomSourceInternal.create(this.getConstructor(), new Object[]{nativeSeed});
        }

        RestorableUniformRandomProvider create(Object seed, Object[] constructorArgs) {
            Object nativeSeed = this.createNativeSeed(seed);
            Object[] all = new Object[constructorArgs.length + 1];
            all[0] = nativeSeed;
            System.arraycopy(constructorArgs, 0, all, 1, constructorArgs.length);
            return RandomSourceInternal.create(this.getConstructor(), all);
        }

        protected Object createSeed() {
            return this.nativeSeedType.createSeed(this.nativeSeedSize);
        }

        protected byte[] createByteArraySeed(UniformRandomProvider source) {
            return SeedFactory.createByteArray(source, this.getSeedByteSize());
        }

        protected Object convertSeed(Object seed) {
            return this.nativeSeedType.convertSeed(seed, this.nativeSeedSize);
        }

        private Object createNativeSeed(Object seed) {
            return seed == null ? this.createSeed() : this.convertSeed(seed);
        }

        public final byte[] createSeedBytes() {
            Object seed = this.createSeed();
            return NativeSeedType.convertSeedToBytes(seed);
        }

        public final byte[] createSeedBytes(UniformRandomProvider source) {
            return this.createByteArraySeed(source);
        }

        private Constructor<?> getConstructor() {
            Constructor<?> constructor = this.rngConstructor;
            if (constructor == null) {
                this.rngConstructor = constructor = this.createConstructor();
            }
            return constructor;
        }

        private Constructor<?> createConstructor() {
            try {
                return this.getRng().getConstructor(this.getArgs());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(ProviderBuilder.INTERNAL_ERROR_MSG, e);
            }
        }

        private static RestorableUniformRandomProvider create(Constructor<?> rng, Object[] args) {
            try {
                return (RestorableUniformRandomProvider)rng.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(ProviderBuilder.INTERNAL_ERROR_MSG, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(ProviderBuilder.INTERNAL_ERROR_MSG, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(ProviderBuilder.INTERNAL_ERROR_MSG, e);
            }
        }
    }
}

