/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import java.security.SecureRandom;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.source64.XoRoShiRo1024PlusPlus;
import org.apache.commons.rng.core.util.NumberFactory;

public final class SeedFactory {
    private static final int XO_RO_SHI_RO_1024_STATE_SIZE = 16;
    private static final int INT_ARRAY_BLOCK_SIZE = 8;
    private static final int LONG_ARRAY_BLOCK_SIZE = 4;
    private static final ReentrantLock LOCK = new ReentrantLock(false);
    private static final UniformRandomProvider SEED_GENERATOR;

    private SeedFactory() {
    }

    public static int createInt() {
        LOCK.lock();
        try {
            int n = SEED_GENERATOR.nextInt();
            return n;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static long createLong() {
        LOCK.lock();
        try {
            long l = SEED_GENERATOR.nextLong();
            return l;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static int[] createIntArray(int n) {
        int[] seed = new int[n];
        int blockSize = 8 * (n / 8);
        int i = 0;
        while (i < blockSize) {
            int end = i + 8;
            SeedFactory.fillIntArray(seed, i, end);
            i = end;
        }
        if (i != n) {
            SeedFactory.fillIntArray(seed, i, n);
        }
        SeedFactory.ensureNonZero(seed);
        return seed;
    }

    public static long[] createLongArray(int n) {
        long[] seed = new long[n];
        int blockSize = 4 * (n / 4);
        int i = 0;
        while (i < blockSize) {
            int end = i + 4;
            SeedFactory.fillLongArray(seed, i, end);
            i = end;
        }
        if (i != n) {
            SeedFactory.fillLongArray(seed, i, n);
        }
        SeedFactory.ensureNonZero(seed);
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillIntArray(int[] array, int start, int end) {
        LOCK.lock();
        try {
            for (int i = start; i < end; ++i) {
                array[i] = SEED_GENERATOR.nextInt();
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillLongArray(long[] array, int start, int end) {
        LOCK.lock();
        try {
            for (int i = start; i < end; ++i) {
                array[i] = SEED_GENERATOR.nextLong();
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    static byte[] createByteArray(UniformRandomProvider source, int n) {
        byte[] seed = new byte[n];
        source.nextBytes(seed);
        SeedFactory.ensureNonZero(seed);
        return seed;
    }

    static void ensureNonZero(int[] seed) {
        if (seed.length != 0 && seed[0] == 0) {
            do {
                seed[0] = SeedFactory.createInt();
            } while (seed[0] == 0);
        }
    }

    static void ensureNonZero(long[] seed) {
        if (seed.length != 0 && seed[0] == 0L) {
            do {
                seed[0] = SeedFactory.createLong();
            } while (seed[0] == 0L);
        }
    }

    private static void ensureNonZero(byte[] seed) {
        if (seed.length != 0 && SeedFactory.isAllZero(seed)) {
            do {
                seed[0] = (byte)SeedFactory.createInt();
            } while (seed[0] == 0);
        }
    }

    private static boolean isAllZero(byte[] array) {
        for (byte value : array) {
            if (value == 0) continue;
            return false;
        }
        return true;
    }

    static long ensureNonZero(RandomLongSource source, long value) {
        long result = value;
        while (result == 0L) {
            result = source.next();
        }
        return result;
    }

    static {
        SecureRandom seedGen = new SecureRandom();
        byte[] bytes = new byte[128];
        seedGen.nextBytes(bytes);
        long[] seed = NumberFactory.makeLongArray((byte[])bytes);
        SplitMix64 rng = new SplitMix64(seed[0]);
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedFactory.ensureNonZero((RandomLongSource)rng, seed[i]);
        }
        SEED_GENERATOR = new XoRoShiRo1024PlusPlus(seed);
    }
}

