/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.EditDistance;

public class EditDistanceFrom<R> {
    private final EditDistance<R> editDistance;
    private final CharSequence left;

    public EditDistanceFrom(EditDistance<R> editDistance, CharSequence left) {
        if (editDistance == null) {
            throw new IllegalArgumentException("The edit distance may not be null.");
        }
        this.editDistance = editDistance;
        this.left = left;
    }

    public R apply(CharSequence right) {
        return this.editDistance.apply(this.left, right);
    }

    public CharSequence getLeft() {
        return this.left;
    }

    public EditDistance<R> getEditDistance() {
        return this.editDistance;
    }
}

