/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl.asn1;

import java.io.UnsupportedEncodingException;
import org.apache.commons.ssl.asn1.DERObject;

public abstract class DERString
extends DERObject {
    DERString(int tag, byte[] value) {
        super(tag, value);
    }

    public String getString() {
        return DERString.byteArrayToString(this.value);
    }

    protected static String byteArrayToString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    protected static byte[] stringToByteArray(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[0];
        }
    }
}

