/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.management;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.continuum.dao.BuildDefinitionDao;
import org.apache.continuum.dao.BuildDefinitionTemplateDao;
import org.apache.continuum.dao.BuildQueueDao;
import org.apache.continuum.dao.ContinuumReleaseResultDao;
import org.apache.continuum.dao.DaoUtils;
import org.apache.continuum.dao.DirectoryPurgeConfigurationDao;
import org.apache.continuum.dao.DistributedDirectoryPurgeConfigurationDao;
import org.apache.continuum.dao.InstallationDao;
import org.apache.continuum.dao.LocalRepositoryDao;
import org.apache.continuum.dao.ProfileDao;
import org.apache.continuum.dao.ProjectGroupDao;
import org.apache.continuum.dao.ProjectScmRootDao;
import org.apache.continuum.dao.RepositoryPurgeConfigurationDao;
import org.apache.continuum.dao.ScheduleDao;
import org.apache.continuum.dao.SystemConfigurationDao;
import org.apache.continuum.model.project.ProjectScmRoot;
import org.apache.continuum.model.release.ContinuumReleaseResult;
import org.apache.continuum.model.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.model.repository.LocalRepository;
import org.apache.continuum.utils.ProjectSorter;
import org.apache.maven.continuum.management.DataManagementException;
import org.apache.maven.continuum.management.DataManagementTool;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildQueue;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.project.io.stax.ContinuumStaxReader;
import org.apache.maven.continuum.model.project.io.stax.ContinuumStaxWriter;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.jdo.ConfigurableJdoFactory;
import org.codehaus.plexus.jdo.PlexusJdoUtils;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdoDataManagementTool
implements DataManagementTool {
    private Logger log = LoggerFactory.getLogger(JdoDataManagementTool.class);
    private DaoUtils daoUtils;
    private LocalRepositoryDao localRepositoryDao;
    private DirectoryPurgeConfigurationDao directoryPurgeConfigurationDao;
    private RepositoryPurgeConfigurationDao repositoryPurgeConfigurationDao;
    private DistributedDirectoryPurgeConfigurationDao distributedDirectoryPurgeConfigurationDao;
    private InstallationDao installationDao;
    private ProfileDao profileDao;
    private ProjectGroupDao projectGroupDao;
    private ScheduleDao scheduleDao;
    private SystemConfigurationDao systemConfigurationDao;
    private ProjectScmRootDao projectScmRootDao;
    private BuildDefinitionTemplateDao buildDefinitionTemplateDao;
    private ContinuumReleaseResultDao releaseResultDao;
    private BuildQueueDao buildQueueDao;
    private BuildDefinitionDao buildDefinitionDao;
    protected static final String BUILDS_XML = "builds.xml";
    protected ConfigurableJdoFactory factory;

    public void backupDatabase(File backupDirectory) throws IOException {
        ContinuumDatabase database = new ContinuumDatabase();
        try {
            database.setSystemConfiguration(this.systemConfigurationDao.getSystemConfiguration());
        }
        catch (ContinuumStoreException e) {
            throw new DataManagementException((Throwable)e);
        }
        Collection projectGroups = this.projectGroupDao.getAllProjectGroupsWithTheLot();
        database.setProjectGroups(new ArrayList(projectGroups));
        try {
            database.setInstallations(this.installationDao.getAllInstallations());
            database.setBuildDefinitionTemplates(this.buildDefinitionTemplateDao.getAllBuildDefinitionTemplate());
            database.setBuildQueues(this.buildQueueDao.getAllBuildQueues());
            database.setBuildDefinitions(this.buildDefinitionDao.getAllTemplates());
        }
        catch (ContinuumStoreException e) {
            throw new DataManagementException((Throwable)e);
        }
        database.setSchedules(this.scheduleDao.getAllSchedulesByName());
        database.setProfiles(this.profileDao.getAllProfilesByName());
        database.setLocalRepositories(this.localRepositoryDao.getAllLocalRepositories());
        database.setRepositoryPurgeConfigurations(this.repositoryPurgeConfigurationDao.getAllRepositoryPurgeConfigurations());
        database.setDirectoryPurgeConfigurations(this.directoryPurgeConfigurationDao.getAllDirectoryPurgeConfigurations());
        database.setDistributedDirectoryPurgeConfigurations(this.distributedDirectoryPurgeConfigurationDao.getAllDistributedDirectoryPurgeConfigurations());
        database.setProjectScmRoots(this.projectScmRootDao.getAllProjectScmRoots());
        database.setContinuumReleaseResults(this.releaseResultDao.getAllContinuumReleaseResults());
        ContinuumStaxWriter writer = new ContinuumStaxWriter();
        File backupFile = new File(backupDirectory, BUILDS_XML);
        File parentFile = backupFile.getParentFile();
        parentFile.mkdirs();
        FileOutputStream out = new FileOutputStream(backupFile);
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)out, Charset.forName(database.getModelEncoding()));
        try {
            writer.write((Writer)fileWriter, database);
        }
        catch (XMLStreamException e) {
            throw new DataManagementException("Modello failure: unable to write data to StAX writer", (Throwable)e);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    public void eraseDatabase() {
        this.daoUtils.eraseDatabase();
    }

    public void restoreDatabase(File backupDirectory, boolean strict) throws IOException {
        ContinuumDatabase database;
        ContinuumStaxReader reader = new ContinuumStaxReader();
        FileReader fileReader = new FileReader(new File(backupDirectory, BUILDS_XML));
        try {
            database = reader.read((Reader)fileReader, strict);
        }
        catch (XMLStreamException e) {
            throw new DataManagementException((Throwable)e);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.factory.getProperties());
        properties.setProperty("org.jpox.metadata.jdoFileExtension", "jdorepl");
        PersistenceManagerFactory pmf = JDOHelper.getPersistenceManagerFactory((Map)properties);
        PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)database.getSystemConfiguration());
        HashMap<Integer, BuildQueue> buildQueues = new HashMap<Integer, BuildQueue>();
        for (BuildQueue buildQueue : database.getBuildQueues()) {
            buildQueue = (BuildQueue)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)buildQueue);
            buildQueues.put(buildQueue.getId(), buildQueue);
        }
        HashMap<Integer, Schedule> schedules = new HashMap<Integer, Schedule>();
        for (Schedule schedule : database.getSchedules()) {
            schedule.setBuildQueues(this.getBuildQueuesBySchedule(buildQueues, schedule));
            schedule = (Schedule)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)schedule);
            schedules.put(schedule.getId(), schedule);
        }
        HashMap<Integer, Installation> installations = new HashMap<Integer, Installation>();
        for (Installation installation : database.getInstallations()) {
            installation = (Installation)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)installation);
            installations.put(installation.getInstallationId(), installation);
        }
        HashMap<Integer, Profile> profiles = new HashMap<Integer, Profile>();
        for (Profile profile : database.getProfiles()) {
            if (profile.getJdk() != null) {
                profile.setJdk((Installation)installations.get(profile.getJdk().getInstallationId()));
            }
            if (profile.getBuilder() != null) {
                profile.setBuilder((Installation)installations.get(profile.getBuilder().getInstallationId()));
            }
            ArrayList environmentVariables = new ArrayList();
            ListIterator envIt = profile.getEnvironmentVariables().listIterator();
            while (envIt.hasNext()) {
                Installation installation = (Installation)envIt.next();
                environmentVariables.add(installations.get(installation.getInstallationId()));
                envIt.remove();
            }
            profile.setEnvironmentVariables(environmentVariables);
            profile = (Profile)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)profile);
            profiles.put(profile.getId(), profile);
        }
        HashMap<Integer, BuildDefinition> buildDefinitions = new HashMap<Integer, BuildDefinition>();
        for (BuildDefinition buildDefinition : database.getBuildDefinitions()) {
            if (buildDefinition.getSchedule() != null) {
                buildDefinition.setSchedule((Schedule)schedules.get(buildDefinition.getSchedule().getId()));
            }
            if (buildDefinition.getProfile() != null) {
                buildDefinition.setProfile((Profile)profiles.get(buildDefinition.getProfile().getId()));
            }
            buildDefinition = (BuildDefinition)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)buildDefinition);
            buildDefinitions.put(buildDefinition.getId(), buildDefinition);
        }
        HashMap<Integer, LocalRepository> localRepositories = new HashMap<Integer, LocalRepository>();
        for (LocalRepository localRepository : database.getLocalRepositories()) {
            localRepository = (LocalRepository)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)localRepository);
            localRepositories.put(localRepository.getId(), localRepository);
        }
        HashMap<Integer, ProjectGroup> projectGroups = new HashMap<Integer, ProjectGroup>();
        for (ProjectGroup projectGroup : database.getProjectGroups()) {
            projectGroup.setBuildDefinitions(this.processBuildDefinitions(projectGroup.getBuildDefinitions(), schedules, profiles, buildDefinitions));
            for (Project project : projectGroup.getProjects()) {
                project.setBuildDefinitions(this.processBuildDefinitions(project.getBuildDefinitions(), schedules, profiles, buildDefinitions));
            }
            if (projectGroup.getLocalRepository() != null) {
                projectGroup.setLocalRepository((LocalRepository)localRepositories.get(projectGroup.getLocalRepository().getId()));
            }
            projectGroup = (ProjectGroup)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)projectGroup);
            projectGroups.put(projectGroup.getId(), projectGroup);
        }
        HashMap<Integer, ProjectScmRoot> projectScmRoots = new HashMap<Integer, ProjectScmRoot>();
        Set keys = projectGroups.keySet();
        int id = 1;
        for (Integer key : keys) {
            ProjectGroup projectGroup = (ProjectGroup)projectGroups.get(key);
            String url = " ";
            List projects = ProjectSorter.getSortedProjects(this.getProjectsByGroupIdWithDependencies(pmf, projectGroup.getId()), (Logger)this.log);
            for (Project project : projects) {
                if (project.getScmUrl().trim().startsWith(url)) continue;
                url = project.getScmUrl();
                ProjectScmRoot projectScmRoot = new ProjectScmRoot();
                projectScmRoot.setId(id);
                projectScmRoot.setProjectGroup(projectGroup);
                projectScmRoot.setScmRootAddress(url);
                projectScmRoot.setState(project.getState());
                projectScmRoot = (ProjectScmRoot)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)projectScmRoot);
                projectScmRoots.put(projectScmRoot.getId(), projectScmRoot);
                ++id;
            }
        }
        for (DirectoryPurgeConfiguration dirPurge : database.getDirectoryPurgeConfigurations()) {
            if (dirPurge.getSchedule() != null) {
                dirPurge.setSchedule((Schedule)schedules.get(dirPurge.getSchedule().getId()));
            }
            dirPurge = (DirectoryPurgeConfiguration)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)dirPurge);
        }
        for (ContinuumReleaseResult releaseResult : database.getContinuumReleaseResults()) {
            releaseResult.setProjectGroup((ProjectGroup)projectGroups.get(releaseResult.getProjectGroup().getId()));
            ProjectGroup group = releaseResult.getProjectGroup();
            for (Project project : group.getProjects()) {
                if (project.getId() != releaseResult.getProject().getId()) continue;
                try {
                    Project proj = (Project)PlexusJdoUtils.getObjectById((PersistenceManager)pmf.getPersistenceManager(), Project.class, (int)project.getId(), null);
                    releaseResult.setProject(proj);
                }
                catch (Exception e) {
                    throw new DataManagementException((Throwable)e);
                }
            }
            releaseResult = (ContinuumReleaseResult)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)releaseResult);
        }
        for (BuildDefinitionTemplate template : database.getBuildDefinitionTemplates()) {
            template.setBuildDefinitions(this.processBuildDefinitions(template.getBuildDefinitions(), buildDefinitions));
            template = (BuildDefinitionTemplate)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)template);
        }
    }

    private List<Project> getProjectsByGroupIdWithDependencies(PersistenceManagerFactory pmf, int projectGroupId) {
        List allProjects = PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)pmf.getPersistenceManager(), Project.class, (String)"name ascending", (String)"project-dependencies");
        ArrayList<Project> groupProjects = new ArrayList<Project>();
        for (Project project : allProjects) {
            if (project.getProjectGroup().getId() != projectGroupId) continue;
            groupProjects.add(project);
        }
        return groupProjects;
    }

    private List<BuildDefinition> processBuildDefinitions(List<BuildDefinition> buildDefinitions, Map<Integer, Schedule> schedules, Map<Integer, Profile> profiles, Map<Integer, BuildDefinition> buildDefs) {
        ArrayList<BuildDefinition> buildDefsList = new ArrayList<BuildDefinition>();
        for (BuildDefinition def : buildDefinitions) {
            if (buildDefs.get(def.getId()) != null) {
                buildDefsList.add(buildDefs.get(def.getId()));
                continue;
            }
            if (def.getSchedule() != null) {
                def.setSchedule(schedules.get(def.getSchedule().getId()));
            }
            if (def.getProfile() != null) {
                def.setProfile(profiles.get(def.getProfile().getId()));
            }
            buildDefsList.add(def);
        }
        return buildDefsList;
    }

    private List<BuildDefinition> processBuildDefinitions(List<BuildDefinition> buildDefinitions, Map<Integer, BuildDefinition> buildDefs) {
        ArrayList<BuildDefinition> buildDefsList = new ArrayList<BuildDefinition>();
        for (BuildDefinition buildDefinition : buildDefinitions) {
            buildDefsList.add(buildDefs.get(buildDefinition.getId()));
        }
        return buildDefsList;
    }

    private List<BuildQueue> getBuildQueuesBySchedule(Map<Integer, BuildQueue> allBuildQueues, Schedule schedule) {
        ArrayList<BuildQueue> buildQueues = new ArrayList<BuildQueue>();
        for (BuildQueue buildQueue : schedule.getBuildQueues()) {
            buildQueues.add(allBuildQueues.get(buildQueue.getId()));
        }
        return buildQueues;
    }
}

