/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.management;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.continuum.management.DataManagementException;
import org.apache.maven.continuum.management.DataManagementTool;
import org.apache.maven.continuum.model.project.v1_0_9.BuildDefinition;
import org.apache.maven.continuum.model.project.v1_0_9.BuildResult;
import org.apache.maven.continuum.model.project.v1_0_9.ContinuumDatabase;
import org.apache.maven.continuum.model.project.v1_0_9.Project;
import org.apache.maven.continuum.model.project.v1_0_9.ProjectDependency;
import org.apache.maven.continuum.model.project.v1_0_9.ProjectDeveloper;
import org.apache.maven.continuum.model.project.v1_0_9.ProjectGroup;
import org.apache.maven.continuum.model.project.v1_0_9.ProjectNotifier;
import org.apache.maven.continuum.model.project.v1_0_9.Schedule;
import org.apache.maven.continuum.model.project.v1_0_9.io.stax.ContinuumStaxReader;
import org.apache.maven.continuum.model.project.v1_0_9.io.stax.ContinuumStaxWriter;
import org.apache.maven.continuum.model.scm.v1_0_9.ChangeFile;
import org.apache.maven.continuum.model.scm.v1_0_9.ChangeSet;
import org.apache.maven.continuum.model.scm.v1_0_9.ScmResult;
import org.apache.maven.continuum.model.scm.v1_0_9.SuiteResult;
import org.apache.maven.continuum.model.scm.v1_0_9.TestCaseFailure;
import org.apache.maven.continuum.model.scm.v1_0_9.TestResult;
import org.apache.maven.continuum.model.system.v1_0_9.SystemConfiguration;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.jdo.DefaultConfigurableJdoFactory;
import org.codehaus.plexus.jdo.PlexusJdoUtils;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyJdoDataManagementTool
implements DataManagementTool {
    protected static final String BUILDS_XML = "builds.xml";
    protected DefaultConfigurableJdoFactory factory;

    public void backupDatabase(File backupDirectory) throws IOException {
        PersistenceManagerFactory pmf = this.getPersistenceManagerFactory("jdo109");
        ContinuumDatabase database = new ContinuumDatabase();
        try {
            database.setSystemConfiguration(this.retrieveSystemConfiguration(pmf));
        }
        catch (ContinuumStoreException e) {
            throw new DataManagementException((Throwable)e);
        }
        Collection<ProjectGroup> projectGroups = this.retrieveAllProjectGroups(pmf);
        database.setProjectGroups(new ArrayList<ProjectGroup>(projectGroups));
        database.setSchedules(this.retrieveAllSchedules(pmf));
        ContinuumStaxWriter writer = new ContinuumStaxWriter();
        backupDirectory.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(backupDirectory, BUILDS_XML));
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)out, Charset.forName(database.getModelEncoding()));
        try {
            writer.write((Writer)fileWriter, database);
        }
        catch (XMLStreamException e) {
            throw new DataManagementException("Modello failure: unable to write data to StAX writer", (Throwable)e);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    private List retrieveAllSchedules(PersistenceManagerFactory pmf) {
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(pmf), Schedule.class, (String)"name ascending", (String)null);
    }

    private Collection<ProjectGroup> retrieveAllProjectGroups(PersistenceManagerFactory pmf) {
        List<String> fetchGroups = Arrays.asList("project-with-builds", "projectgroup-projects", "build-result-with-details", "project-with-checkout-result", "project-all-details", "project-build-details");
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(pmf), ProjectGroup.class, (String)"name ascending", fetchGroups);
    }

    private SystemConfiguration retrieveSystemConfiguration(PersistenceManagerFactory pmf) throws ContinuumStoreException {
        SystemConfiguration result;
        List systemConfs = PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(pmf), SystemConfiguration.class, null, (String)null);
        if (systemConfs == null || systemConfs.isEmpty()) {
            result = null;
        } else {
            if (systemConfs.size() > 1) {
                throw new ContinuumStoreException("Database is corrupted. There are more than one systemConfiguration object.");
            }
            result = (SystemConfiguration)systemConfs.get(0);
        }
        return result;
    }

    public void eraseDatabase() {
        PersistenceManagerFactory pmf = this.getPersistenceManagerFactory("jdo109");
        PersistenceManager persistenceManager = this.getPersistenceManager(pmf);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ProjectGroup.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, Project.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, Schedule.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ScmResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, BuildResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, TestResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, SuiteResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, TestCaseFailure.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, SystemConfiguration.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ProjectNotifier.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ProjectDeveloper.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ProjectDependency.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ChangeSet.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, ChangeFile.class);
        PlexusJdoUtils.removeAll((PersistenceManager)persistenceManager, BuildDefinition.class);
    }

    private PersistenceManager getPersistenceManager(PersistenceManagerFactory pmf) {
        PersistenceManager pm = pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        pm.getFetchPlan().setDetachmentOptions(1);
        return pm;
    }

    public void restoreDatabase(File backupDirectory, boolean strict) throws IOException {
        ContinuumDatabase database;
        ContinuumStaxReader reader = new ContinuumStaxReader();
        FileReader fileReader = new FileReader(new File(backupDirectory, BUILDS_XML));
        try {
            database = reader.read((Reader)fileReader, strict);
        }
        catch (XMLStreamException e) {
            throw new DataManagementException((Throwable)e);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
        PersistenceManagerFactory pmf = this.getPersistenceManagerFactory("jdorepl109");
        PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)database.getSystemConfiguration());
        HashMap<Integer, Schedule> schedules = new HashMap<Integer, Schedule>();
        for (Schedule schedule : database.getSchedules()) {
            schedule = (Schedule)PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)schedule);
            schedules.put(schedule.getId(), schedule);
        }
        for (ProjectGroup projectGroup : database.getProjectGroups()) {
            LegacyJdoDataManagementTool.processBuildDefinitions(projectGroup.getBuildDefinitions(), schedules);
            for (Project project : projectGroup.getProjects()) {
                LegacyJdoDataManagementTool.processBuildDefinitions(project.getBuildDefinitions(), schedules);
            }
            PlexusJdoUtils.addObject((PersistenceManager)pmf.getPersistenceManager(), (Object)projectGroup);
        }
        pmf.close();
    }

    private PersistenceManagerFactory getPersistenceManagerFactory(String ext) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.factory.getProperties());
        properties.setProperty("org.jpox.metadata.jdoFileExtension", ext);
        return JDOHelper.getPersistenceManagerFactory((Map)properties);
    }

    private static void processBuildDefinitions(List buildDefinitions, Map<Integer, Schedule> schedules) {
        for (BuildDefinition def : buildDefinitions) {
            if (def.getSchedule() == null) continue;
            def.setSchedule(schedules.get(def.getSchedule().getId()));
        }
    }
}

