/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.Future;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferedStatistics;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailResult;
import org.apache.crail.CrailStore;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.utils.CrailUtils;
import org.apache.crail.utils.RingBuffer;
import org.slf4j.Logger;

public abstract class CrailBufferedInputStream
extends InputStream {
    private static final Logger LOG = CrailUtils.getLogger();
    private CrailStore fs;
    private byte[] tmpByteBuf;
    private ByteBuffer tmpBoundaryBuffer;
    private LinkedList<CrailBuffer> originalBuffers;
    private RingBuffer<CrailBuffer> readySlices;
    private RingBuffer<CrailBuffer> pendingSlices;
    private RingBuffer<Future<CrailResult>> pendingFutures;
    private RingBuffer<CrailBuffer> freeSlices;
    private RingBuffer<CrailBuffer> tmpSlices;
    private long position;
    private boolean open;
    private CrailBufferedStatistics statistics;
    private int actualSliceSize;
    private long capacity;

    public abstract CrailInputStream getStream() throws Exception;

    public abstract void putStream() throws Exception;

    CrailBufferedInputStream(CrailStore fs, int queueDepth, long capacity) throws Exception {
        this.fs = fs;
        this.position = 0L;
        this.capacity = capacity;
        this.tmpByteBuf = new byte[1];
        this.tmpBoundaryBuffer = ByteBuffer.allocate(8);
        this.statistics = new CrailBufferedStatistics("buffered/in");
        this.actualSliceSize = Math.min(CrailConstants.BUFFER_SIZE, CrailConstants.SLICE_SIZE);
        int allocationSize = queueDepth * this.actualSliceSize;
        this.originalBuffers = new LinkedList();
        this.readySlices = new RingBuffer(queueDepth);
        this.pendingSlices = new RingBuffer(queueDepth);
        this.freeSlices = new RingBuffer(queueDepth);
        this.pendingFutures = new RingBuffer(queueDepth);
        this.tmpSlices = new RingBuffer(queueDepth);
        for (int currentSize = 0; currentSize < allocationSize; currentSize += CrailConstants.BUFFER_SIZE) {
            CrailBuffer buffer = fs.allocateBuffer();
            this.originalBuffers.add(buffer);
        }
        block1: for (CrailBuffer buffer : this.originalBuffers) {
            while (buffer.hasRemaining()) {
                buffer.limit(buffer.position() + this.actualSliceSize);
                CrailBuffer slice = buffer.slice();
                slice.clear();
                this.freeSlices.add(slice);
                if (this.freeSlices.size() >= queueDepth) continue block1;
                int newpos = buffer.position() + this.actualSliceSize;
                buffer.clear();
                buffer.position(newpos);
            }
        }
        this.open = true;
    }

    @Override
    public final int read() throws IOException {
        int ret = this.read(this.tmpByteBuf);
        return ret <= 0 ? -1 : this.tmpByteBuf[0] & 0xFF;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(long position, byte[] buffer, int offset, int length) throws IOException {
        long oldPos = this.position();
        int nread = -1;
        try {
            this.seek(position);
            nread = this.read(buffer, offset, length);
        }
        finally {
            this.seek(oldPos);
        }
        return nread;
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        try {
            CrailBuffer slice;
            if (buf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > buf.length - off) {
                throw new IndexOutOfBoundsException("off " + off + ", len " + len + ", length " + buf.length);
            }
            if (!this.open) {
                throw new IOException("strem closed");
            }
            if (len == 0) {
                return 0;
            }
            int sumLen = 0;
            while (len > 0 && (slice = this.getSlice(true)) != null) {
                int bufferRemaining = Math.min(len, slice.remaining());
                slice.get(buf, off, bufferRemaining);
                len -= bufferRemaining;
                off += bufferRemaining;
                sumLen += bufferRemaining;
                this.position += (long)bufferRemaining;
                this.syncSlice();
            }
            if (sumLen > 0) {
                return sumLen;
            }
            if (this.readySlices.size() + this.pendingSlices.size() > 0) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    public final int read(ByteBuffer dataBuf) throws IOException {
        try {
            CrailBuffer slice;
            if (dataBuf == null) {
                throw new NullPointerException();
            }
            if (!this.open) {
                throw new IOException("strem closed");
            }
            if (dataBuf.remaining() == 0) {
                return 0;
            }
            int len = dataBuf.remaining();
            int sumLen = 0;
            while (len > 0 && (slice = this.getSlice(true)) != null) {
                int bufferRemaining = Math.min(len, slice.remaining());
                int oldLimit = slice.limit();
                slice.limit(slice.position() + bufferRemaining);
                dataBuf.put(slice.getByteBuffer());
                slice.limit(oldLimit);
                len -= bufferRemaining;
                sumLen += bufferRemaining;
                this.position += (long)bufferRemaining;
                this.syncSlice();
            }
            if (sumLen > 0) {
                return sumLen;
            }
            if (this.readySlices.size() + this.pendingSlices.size() > 0) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public final double readDouble() throws Exception {
        CrailBuffer slice = this.getSlice(true);
        if (slice == null) {
            throw new EOFException();
        }
        if (slice.remaining() >= 8) {
            double val = slice.getDouble();
            this.position += 8L;
            this.syncSlice();
            return val;
        }
        this.tmpBoundaryBuffer.clear();
        this.tmpBoundaryBuffer.limit(8);
        this.read(this.tmpBoundaryBuffer);
        this.tmpBoundaryBuffer.flip();
        return this.tmpBoundaryBuffer.getDouble();
    }

    public final float readFloat() throws Exception {
        CrailBuffer slice = this.getSlice(true);
        if (slice == null) {
            throw new EOFException();
        }
        if (slice.remaining() >= 4) {
            float val = slice.getFloat();
            this.position += 4L;
            this.syncSlice();
            return val;
        }
        this.tmpBoundaryBuffer.clear();
        this.tmpBoundaryBuffer.limit(4);
        this.read(this.tmpBoundaryBuffer);
        this.tmpBoundaryBuffer.flip();
        return this.tmpBoundaryBuffer.getFloat();
    }

    public final int readInt() throws Exception {
        CrailBuffer slice = this.getSlice(true);
        if (slice == null) {
            throw new EOFException();
        }
        if (slice.remaining() >= 4) {
            int val = slice.getInt();
            this.position += 4L;
            this.syncSlice();
            return val;
        }
        this.tmpBoundaryBuffer.clear();
        this.tmpBoundaryBuffer.limit(4);
        this.read(this.tmpBoundaryBuffer);
        this.tmpBoundaryBuffer.flip();
        return this.tmpBoundaryBuffer.getInt();
    }

    public final long readLong() throws Exception {
        CrailBuffer slice = this.getSlice(true);
        if (slice == null) {
            throw new EOFException();
        }
        if (slice.remaining() >= 8) {
            long val = slice.getLong();
            this.position += 8L;
            this.syncSlice();
            return val;
        }
        this.tmpBoundaryBuffer.clear();
        this.tmpBoundaryBuffer.limit(8);
        this.read(this.tmpBoundaryBuffer);
        this.tmpBoundaryBuffer.flip();
        return this.tmpBoundaryBuffer.getLong();
    }

    public final short readShort() throws Exception {
        CrailBuffer slice = this.getSlice(true);
        if (slice == null) {
            throw new EOFException();
        }
        if (slice.remaining() >= 2) {
            short val = slice.getShort();
            this.position += 2L;
            this.syncSlice();
            return val;
        }
        this.tmpBoundaryBuffer.clear();
        this.tmpBoundaryBuffer.limit(2);
        this.read(this.tmpBoundaryBuffer);
        this.tmpBoundaryBuffer.flip();
        return this.tmpBoundaryBuffer.getShort();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.open) {
                return;
            }
            while (!this.pendingFutures.isEmpty()) {
                Future<CrailResult> future = this.pendingFutures.poll();
                future.get();
            }
            while (!this.originalBuffers.isEmpty()) {
                CrailBuffer buffer = this.originalBuffers.remove();
                this.fs.freeBuffer(buffer);
            }
            this.fs.getStatistics().addProvider(this.statistics);
            this.open = false;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long oldPos = this.position();
        this.seek(oldPos + n);
        long newPos = this.position();
        if (newPos >= oldPos) {
            return newPos - oldPos;
        }
        throw new IOException("Error in skip operation");
    }

    public void seek(long pos) throws IOException {
        try {
            if (pos >= this.capacity) {
                return;
            }
            if (pos == this.position) {
                return;
            }
            long startPosition = CrailUtils.bufferStartAddress(this.position, this.actualSliceSize);
            long endPosition = startPosition + (long)((this.readySlices.size() + this.pendingSlices.size()) * this.actualSliceSize);
            if (pos >= startPosition && pos < endPosition) {
                long currentPosition = startPosition;
                this.tmpSlices.clear();
                while (!this.freeSlices.isEmpty()) {
                    this.tmpSlices.add(this.freeSlices.poll());
                }
                while (!this.readySlices.isEmpty() && pos >= currentPosition + (long)this.actualSliceSize) {
                    currentPosition += (long)this.actualSliceSize;
                    this.tmpSlices.add(this.readySlices.poll());
                }
                while (!this.pendingFutures.isEmpty() && pos >= currentPosition + (long)this.actualSliceSize) {
                    Future<CrailResult> future = this.pendingFutures.poll();
                    future.get();
                    currentPosition += (long)this.actualSliceSize;
                    this.tmpSlices.add(this.pendingSlices.poll());
                }
                while (!this.tmpSlices.isEmpty()) {
                    this.triggerRead(this.tmpSlices.poll());
                }
                this.position = pos;
                CrailBuffer slice = this.getSlice(true);
                long bufPosition = pos - currentPosition;
                slice.position((int)bufPosition);
            } else {
                long sliceStart = CrailUtils.bufferStartAddress(pos, this.actualSliceSize);
                this.getStream().seek(sliceStart);
                this.tmpSlices.clear();
                while (!this.freeSlices.isEmpty()) {
                    this.tmpSlices.add(this.freeSlices.poll());
                }
                while (!this.readySlices.isEmpty()) {
                    this.tmpSlices.add(this.readySlices.poll());
                }
                while (!this.pendingFutures.isEmpty()) {
                    Future<CrailResult> future = this.pendingFutures.poll();
                    future.get();
                    this.tmpSlices.add(this.pendingSlices.poll());
                }
                while (!this.tmpSlices.isEmpty()) {
                    this.triggerRead(this.tmpSlices.poll());
                }
                this.position = pos;
                CrailBuffer slice = this.getSlice(true);
                long bufPosition = pos - sliceStart;
                slice.position((int)bufPosition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("position " + this.position + ", pos " + pos + ", free " + this.freeSlices.size() + ", ready " + this.readySlices.size() + ", pending " + this.pendingSlices.size() + ", capacity " + this.capacity + ", exception " + e);
        }
    }

    @Override
    public int available() {
        try {
            CrailBuffer buffer = this.getSlice(false);
            if (buffer != null) {
                return buffer.remaining();
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public long position() {
        return this.position;
    }

    private CrailBuffer getSlice(boolean blocking) throws Exception {
        CrailBuffer slice = this.readySlices.peek();
        if (slice == null) {
            Future<CrailResult> future = this.pendingFutures.peek();
            if (future == null) {
                this.tmpSlices.clear();
                while (!this.freeSlices.isEmpty()) {
                    this.tmpSlices.add(this.freeSlices.poll());
                }
                while (!this.tmpSlices.isEmpty()) {
                    this.triggerRead(this.tmpSlices.poll());
                }
                future = this.pendingFutures.peek();
            }
            if (future != null) {
                this.statistics.incTotalOps();
                if (blocking) {
                    future.get();
                }
                if (future.isDone()) {
                    future = this.pendingFutures.poll();
                    this.statistics.incNonBlockingOps();
                    slice = this.pendingSlices.poll();
                    slice.flip();
                    this.readySlices.add(slice);
                } else {
                    slice = null;
                }
            } else {
                slice = null;
            }
        }
        return slice;
    }

    private void syncSlice() throws Exception {
        CrailBuffer slice = this.readySlices.peek();
        if (slice != null && slice.remaining() == 0) {
            slice = this.readySlices.poll();
            this.triggerRead(slice);
        }
    }

    private void triggerRead(CrailBuffer slice) throws Exception {
        slice.clear();
        CrailInputStream inputStream = this.getStream();
        if (inputStream != null) {
            Future<CrailResult> future = inputStream.read(slice);
            if (future != null) {
                this.pendingSlices.add(slice);
                this.pendingFutures.add(future);
            } else {
                this.freeSlices.add(slice);
            }
            this.putStream();
        }
    }
}

