/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.Future;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferedStatistics;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailOutputStream;
import org.apache.crail.CrailPurgeOperation;
import org.apache.crail.CrailResult;
import org.apache.crail.CrailStore;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.utils.CrailImmediateOperation;
import org.apache.crail.utils.CrailUtils;
import org.apache.crail.utils.RingBuffer;
import org.slf4j.Logger;

public class CrailBufferedOutputStream
extends OutputStream {
    public static final Logger LOG = CrailUtils.getLogger();
    private CrailStore crailFS;
    private CrailFile file;
    private long writeHint;
    private CrailOutputStream outputStream;
    private LinkedList<CrailBuffer> originalBuffers;
    private RingBuffer<CrailBuffer> readySlices;
    private RingBuffer<CrailBuffer> pendingSlices;
    private RingBuffer<Future<CrailResult>> pendingFutures;
    private long position;
    private boolean open;
    private CrailBufferedStatistics statistics;
    private int actualSliceSize;
    private CrailImmediateOperation noOp;
    private ByteBuffer tmpBoundaryBuffer;
    private byte[] tmpByteBuf;

    CrailBufferedOutputStream(CrailFile file, long writeHint) throws Exception {
        this.crailFS = file.getFileSystem();
        this.file = file;
        this.writeHint = writeHint;
        this.outputStream = null;
        this.statistics = new CrailBufferedStatistics("buffered/out");
        int allocationSize = Math.max(CrailConstants.BUFFER_SIZE, CrailConstants.SLICE_SIZE);
        this.actualSliceSize = Math.min(CrailConstants.BUFFER_SIZE, CrailConstants.SLICE_SIZE);
        int sliceCount = allocationSize / this.actualSliceSize;
        this.originalBuffers = new LinkedList();
        this.readySlices = new RingBuffer(sliceCount);
        this.pendingSlices = new RingBuffer(sliceCount);
        this.pendingFutures = new RingBuffer(sliceCount);
        for (int currentSize = 0; currentSize < allocationSize; currentSize += CrailConstants.BUFFER_SIZE) {
            CrailBuffer buffer = this.crailFS.allocateBuffer();
            this.originalBuffers.add(buffer);
        }
        for (CrailBuffer buffer : this.originalBuffers) {
            while (buffer.hasRemaining()) {
                buffer.limit(buffer.position() + this.actualSliceSize);
                CrailBuffer slice = buffer.slice();
                slice.clear();
                this.readySlices.add(slice);
                int newpos = buffer.position() + this.actualSliceSize;
                buffer.clear();
                buffer.position(newpos);
            }
        }
        CrailBuffer firstSlice = this.readySlices.peek();
        long streamPosition = this.outputStream().position();
        firstSlice.limit(firstSlice.remaining() - (int)(streamPosition % (long)firstSlice.remaining()));
        this.tmpByteBuf = new byte[1];
        this.tmpBoundaryBuffer = ByteBuffer.allocate(8);
        this.noOp = new CrailImmediateOperation(0);
        this.position = 0L;
        this.open = true;
    }

    @Override
    public final void write(int dataBuf) throws IOException {
        this.tmpByteBuf[0] = (byte)dataBuf;
        this.write(this.tmpByteBuf);
    }

    @Override
    public final void write(byte[] dataBuf) throws IOException {
        this.write(dataBuf, 0, dataBuf.length);
    }

    @Override
    public final void write(byte[] dataBuf, int off, int len) throws IOException {
        try {
            if (dataBuf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > dataBuf.length || len < 0 || off + len > dataBuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!this.open) {
                throw new IOException("stream closed");
            }
            if (len == 0) {
                return;
            }
            while (len > 0) {
                CrailBuffer slice = this.getSlice();
                int bufferRemaining = Math.min(len, slice.remaining());
                slice.put(dataBuf, off, bufferRemaining);
                off += bufferRemaining;
                len -= bufferRemaining;
                this.position += (long)bufferRemaining;
                this.syncSlice();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public final void write(ByteBuffer dataBuf) throws IOException {
        try {
            if (dataBuf == null) {
                throw new NullPointerException();
            }
            if (!this.open) {
                throw new IOException("stream closed");
            }
            if (dataBuf.remaining() == 0) {
                return;
            }
            int len = dataBuf.remaining();
            while (len > 0) {
                CrailBuffer slice = this.getSlice();
                int bufferRemaining = Math.min(len, slice.remaining());
                int oldLimit = dataBuf.limit();
                dataBuf.limit(dataBuf.position() + bufferRemaining);
                slice.put(dataBuf);
                dataBuf.limit(oldLimit);
                len -= bufferRemaining;
                this.position += (long)bufferRemaining;
                this.syncSlice();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public final void writeDouble(double value) throws Exception {
        CrailBuffer slice = this.getSlice();
        if (slice.remaining() >= 8) {
            slice.putDouble(value);
            this.syncSlice();
            this.position += 8L;
        } else {
            this.tmpBoundaryBuffer.clear();
            this.tmpBoundaryBuffer.putDouble(value);
            this.tmpBoundaryBuffer.flip();
            this.write(this.tmpBoundaryBuffer);
        }
    }

    public final void writeFloat(float value) throws Exception {
        CrailBuffer slice = this.getSlice();
        if (slice.remaining() >= 4) {
            slice.putFloat(value);
            this.syncSlice();
            this.position += 4L;
        } else {
            this.tmpBoundaryBuffer.clear();
            this.tmpBoundaryBuffer.putFloat(value);
            this.tmpBoundaryBuffer.flip();
            this.write(this.tmpBoundaryBuffer);
        }
    }

    public final void writeInt(int value) throws Exception {
        CrailBuffer slice = this.getSlice();
        if (slice.remaining() >= 4) {
            slice.putInt(value);
            this.syncSlice();
            this.position += 4L;
        } else {
            this.tmpBoundaryBuffer.clear();
            this.tmpBoundaryBuffer.putInt(value);
            this.tmpBoundaryBuffer.flip();
            this.write(this.tmpBoundaryBuffer);
        }
    }

    public final void writeLong(long value) throws Exception {
        CrailBuffer slice = this.getSlice();
        if (slice.remaining() >= 8) {
            slice.putLong(value);
            this.syncSlice();
            this.position += 8L;
        } else {
            this.tmpBoundaryBuffer.clear();
            this.tmpBoundaryBuffer.putLong(value);
            this.tmpBoundaryBuffer.flip();
            this.write(this.tmpBoundaryBuffer);
        }
    }

    public final void writeShort(short value) throws Exception {
        CrailBuffer slice = this.getSlice();
        if (slice.remaining() >= 2) {
            slice.putShort(value);
            this.syncSlice();
            this.position += 2L;
        } else {
            this.tmpBoundaryBuffer.clear();
            this.tmpBoundaryBuffer.putShort(value);
            this.tmpBoundaryBuffer.flip();
            this.write(this.tmpBoundaryBuffer);
        }
    }

    public Future<CrailResult> purge() throws IOException {
        if (!this.open) {
            throw new IOException("stream closed");
        }
        try {
            Future<CrailResult> future;
            while (!this.readySlices.isEmpty()) {
                CrailBuffer slice = this.readySlices.poll();
                if (slice.position() <= 0) continue;
                slice.flip();
                future = this.outputStream().write(slice);
                this.pendingSlices.add(slice);
                this.pendingFutures.add(future);
            }
            if (this.pendingFutures.isEmpty()) {
                return this.noOp;
            }
            CrailPurgeOperation purgeOp = new CrailPurgeOperation();
            while (!this.pendingFutures.isEmpty()) {
                future = this.pendingFutures.poll();
                purgeOp.add(future);
            }
            return purgeOp;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Future<Void> sync() throws IOException {
        Future<Void> future = this.outputStream().sync();
        return future;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.open) {
                return;
            }
            while (!this.readySlices.isEmpty()) {
                CrailBuffer slice = this.readySlices.poll();
                if (slice.position() <= 0) continue;
                slice.flip();
                Future<CrailResult> future = this.outputStream().write(slice);
                this.pendingSlices.add(slice);
                this.pendingFutures.add(future);
            }
            while (!this.pendingFutures.isEmpty()) {
                Future<CrailResult> future = this.pendingFutures.poll();
                future.get();
            }
            while (!this.originalBuffers.isEmpty()) {
                CrailBuffer buffer = this.originalBuffers.remove();
                this.crailFS.freeBuffer(buffer);
            }
            this.outputStream().close();
            this.crailFS.getStatistics().addProvider(this.statistics);
            this.open = false;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public long position() {
        return this.position;
    }

    @Override
    public void flush() throws IOException {
    }

    public CrailNode getFile() throws IOException {
        return this.outputStream().getFile();
    }

    private CrailBuffer getSlice() throws Exception {
        CrailBuffer slice = this.readySlices.peek();
        if (slice == null) {
            Future<CrailResult> future = this.pendingFutures.poll();
            this.statistics.incTotalOps();
            if (future.isDone()) {
                this.statistics.incNonBlockingOps();
            } else {
                this.statistics.incBlockingOps();
            }
            future.get();
            slice = this.pendingSlices.poll();
            slice.clear();
            this.readySlices.add(slice);
        }
        return slice;
    }

    private void syncSlice() throws Exception {
        CrailBuffer slice = this.readySlices.peek();
        if (slice != null && slice.remaining() == 0) {
            slice = this.readySlices.poll();
            slice.flip();
            Future<CrailResult> future = this.outputStream().write(slice);
            this.pendingSlices.add(slice);
            this.pendingFutures.add(future);
        }
    }

    final CrailOutputStream outputStream() throws IOException {
        if (this.outputStream == null) {
            try {
                this.outputStream = this.file.getDirectOutputStream(this.writeHint);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this.outputStream;
    }
}

