/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailStatistics;

class CrailBufferedStatistics
implements CrailStatistics.StatisticsProvider {
    private String type;
    private AtomicLong totalOps;
    private AtomicLong blockingOps;
    private AtomicLong nonBlockingOps;

    public CrailBufferedStatistics(String type) {
        this.type = type;
        this.totalOps = new AtomicLong(0L);
        this.blockingOps = new AtomicLong(0L);
        this.nonBlockingOps = new AtomicLong(0L);
    }

    @Override
    public void mergeStatistics(CrailStatistics.StatisticsProvider provider) {
        if (provider instanceof CrailBufferedStatistics) {
            CrailBufferedStatistics newProvider = (CrailBufferedStatistics)provider;
            this.totalOps.addAndGet(newProvider.getTotalOps());
            this.blockingOps.addAndGet(newProvider.getBlockingOps());
            this.nonBlockingOps.addAndGet(newProvider.getNonBlockingOps());
        }
    }

    @Override
    public String providerName() {
        return this.type;
    }

    @Override
    public String printStatistics() {
        return "totalOps " + this.getTotalOps() + ", blockingOps " + this.getBlockingOps() + ", nonBlockingOps " + this.getNonBlockingOps();
    }

    @Override
    public void resetStatistics() {
        this.totalOps.set(0L);
        this.blockingOps.set(0L);
        this.nonBlockingOps.set(0L);
    }

    public void incTotalOps() {
        this.totalOps.incrementAndGet();
    }

    public void incBlockingOps() {
        this.blockingOps.incrementAndGet();
    }

    public void incNonBlockingOps() {
        this.nonBlockingOps.incrementAndGet();
    }

    public long getTotalOps() {
        return this.totalOps.get();
    }

    public long getBlockingOps() {
        return this.blockingOps.get();
    }

    public long getNonBlockingOps() {
        return this.nonBlockingOps.get();
    }
}

