/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class CrailStatistics {
    private static final Logger LOG = CrailUtils.getLogger();
    private ConcurrentHashMap<String, StatisticsProvider> statistics = new ConcurrentHashMap();

    public void addProvider(StatisticsProvider provider) {
        StatisticsProvider existing = this.statistics.putIfAbsent(provider.providerName(), provider);
        if (existing != null) {
            existing.mergeStatistics(provider);
        }
    }

    public void print(String tag) {
        LOG.info("CrailStatistics, tag=" + tag);
        for (StatisticsProvider provider : this.statistics.values()) {
            LOG.info("provider=" + provider.providerName() + " [" + provider.printStatistics() + "]");
        }
    }

    public void reset() {
        for (StatisticsProvider provider : this.statistics.values()) {
            provider.resetStatistics();
        }
    }

    public static interface StatisticsProvider {
        public String providerName();

        public String printStatistics();

        public void mergeStatistics(StatisticsProvider var1);

        public void resetStatistics();
    }
}

