/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailLocationClass;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailStatistics;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.Upcoming;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public abstract class CrailStore {
    private static final Logger LOG = CrailUtils.getLogger();
    private static AtomicLong referenceCounter = new AtomicLong(0L);
    private static CrailStore instance = null;

    public abstract Upcoming<CrailNode> create(String var1, CrailNodeType var2, CrailStorageClass var3, CrailLocationClass var4, boolean var5) throws Exception;

    public abstract Upcoming<CrailNode> lookup(String var1) throws Exception;

    public abstract Upcoming<CrailNode> rename(String var1, String var2) throws Exception;

    public abstract Upcoming<CrailNode> delete(String var1, boolean var2) throws Exception;

    public abstract CrailBuffer allocateBuffer() throws Exception;

    public abstract void freeBuffer(CrailBuffer var1) throws Exception;

    public abstract CrailStatistics getStatistics();

    public abstract CrailLocationClass getLocationClass();

    protected abstract void closeFileSystem() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        AtomicLong atomicLong = referenceCounter;
        synchronized (atomicLong) {
            if (CrailConstants.SINGLETON) {
                long counter = referenceCounter.decrementAndGet();
                if (counter == 0L) {
                    LOG.info("Closing CrailFS singleton");
                    try {
                        this.closeFileSystem();
                        instance = null;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            } else {
                LOG.info("Closing CrailFS non-singleton");
                try {
                    this.closeFileSystem();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrailStore newInstance(CrailConfiguration conf) throws Exception {
        AtomicLong atomicLong = referenceCounter;
        synchronized (atomicLong) {
            boolean isSingleton = conf.getBoolean("crail.singleton", CrailConstants.SINGLETON);
            if (isSingleton) {
                referenceCounter.incrementAndGet();
                if (instance == null) {
                    LOG.info("creating singleton crail file system");
                    instance = new CoreDataStore(conf);
                    return instance;
                }
                LOG.info("returning singleton crail file system");
                return instance;
            }
            LOG.info("creating non-singleton crail file system");
            return new CoreDataStore(conf);
        }
    }
}

