/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class CrailConfiguration {
    private static final Logger LOG = CrailUtils.getLogger();
    private ConcurrentHashMap<String, String> conf = new ConcurrentHashMap();

    public CrailConfiguration() throws IOException {
        Properties properties = CrailConfiguration.loadProperties("crail-site.conf");
        this.mergeProperties(properties);
    }

    private static String expandEnvVars(String input) throws IOException {
        if (null == input) {
            return null;
        }
        Pattern p = Pattern.compile("\\$\\{(\\w+)\\}|\\$(\\w+)");
        Matcher m = p.matcher(input);
        StringBuffer output = new StringBuffer();
        while (m.find()) {
            String envVar = m.group(1) != null ? m.group(1) : m.group(2);
            String envVal = System.getenv(envVar);
            if (envVal == null) {
                throw new IOException("Could not expand environment variable $" + envVar);
            }
            m.appendReplacement(output, envVal);
        }
        m.appendTail(output);
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resourceName) throws IOException {
        Properties properties = new Properties();
        String base = System.getenv("CRAIL_HOME");
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("CRAIL_HOME environment variable is not set or empty");
        }
        try (FileInputStream inputStream = new FileInputStream(new File(base + "/conf/" + resourceName));){
            properties.load(inputStream);
        }
        for (String key : properties.stringPropertyNames()) {
            String val = properties.getProperty(key);
            properties.setProperty(key, CrailConfiguration.expandEnvVars(val));
        }
        return properties;
    }

    public String get(String key) {
        return this.conf.get(key);
    }

    public void set(String key, String value) {
        this.conf.put(key, value);
    }

    public boolean getBoolean(String key, boolean fallback) {
        if (this.conf.containsKey(key)) {
            return Boolean.parseBoolean(this.conf.get(key));
        }
        return fallback;
    }

    public void setInt(String key, int level) {
        String value = Integer.toString(level);
        this.conf.put(key, value);
    }

    private void mergeProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (String key : properties.stringPropertyNames()) {
            this.conf.put(key.trim(), properties.getProperty(key).trim());
        }
    }
}

