/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.Iterator;
import org.apache.crail.CrailContainer;
import org.apache.crail.CrailDirectory;
import org.apache.crail.CrailMultiFile;
import org.apache.crail.CrailTable;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreInputStream;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.CoreOutputStream;
import org.apache.crail.core.DirectoryInputStream;
import org.apache.crail.core.DirectoryOutputStream;
import org.apache.crail.metadata.FileInfo;

class CoreDirectory
extends CoreNode
implements CrailContainer,
CrailDirectory,
CrailMultiFile,
CrailTable {
    public CoreDirectory(CoreDataStore fs, FileInfo fileInfo, String path) {
        super(fs, fileInfo, path);
        this.fs = fs;
        this.fileInfo = fileInfo;
        this.path = path;
    }

    @Override
    public int files() {
        return (int)this.fileInfo.getCapacity() / CrailConstants.DIRECTORY_RECORD;
    }

    @Override
    public Iterator<String> listEntries() throws Exception {
        return this.fs.listEntries(this.path);
    }

    @Override
    public CoreDirectory asDirectory() throws Exception {
        if (!this.getType().isDirectory()) {
            throw new Exception("file type mismatch, type " + (Object)((Object)this.getType()));
        }
        return this;
    }

    @Override
    public CoreDirectory asContainer() throws Exception {
        if (!this.getType().isContainer()) {
            throw new Exception("file type mismatch, type " + (Object)((Object)this.getType()));
        }
        return this;
    }

    @Override
    public CrailMultiFile asMultiFile() throws Exception {
        if (!this.getType().isMultiFile()) {
            throw new Exception("file type mismatch, type " + (Object)((Object)this.getType()));
        }
        return this;
    }

    @Override
    public CrailTable asTable() throws Exception {
        if (!this.getType().isTable()) {
            throw new Exception("file type mismatch, type " + (Object)((Object)this.getType()));
        }
        return this;
    }

    DirectoryOutputStream getDirectoryOutputStream() throws Exception {
        CoreOutputStream outputStream = super.getOutputStream(0L);
        return new DirectoryOutputStream(outputStream);
    }

    DirectoryInputStream getDirectoryInputStream(boolean randomize) throws Exception {
        CoreInputStream inputStream = super.getInputStream(0L);
        return new DirectoryInputStream(inputStream, randomize);
    }
}

