/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import org.apache.crail.CrailBlockLocation;
import org.apache.crail.CrailContainer;
import org.apache.crail.CrailDirectory;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailInputStream;
import org.apache.crail.CrailKeyValue;
import org.apache.crail.CrailMultiFile;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailOutputStream;
import org.apache.crail.CrailStore;
import org.apache.crail.CrailTable;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CreateNodeFuture;

class CoreEarlyFile
implements CrailFile,
CrailKeyValue {
    private CoreDataStore fs;
    private String path;
    private CrailNodeType type;
    private CreateNodeFuture future;
    private CrailFile file;

    public CoreEarlyFile(CoreDataStore fs, String path, CrailNodeType type, CreateNodeFuture future) {
        this.fs = fs;
        this.path = path;
        this.type = type;
        this.future = future;
        this.file = null;
    }

    @Override
    public CrailInputStream getDirectInputStream(long readHint) throws Exception {
        return this.file().getDirectInputStream(readHint);
    }

    @Override
    public synchronized CrailOutputStream getDirectOutputStream(long writeHint) throws Exception {
        return this.file().getDirectOutputStream(writeHint);
    }

    @Override
    public CrailBlockLocation[] getBlockLocations(long start, long len) throws Exception {
        return this.fs.getBlockLocations(this.path, start, len);
    }

    @Override
    public long getToken() {
        return this.file().getToken();
    }

    @Override
    public CrailFile asFile() throws Exception {
        return this;
    }

    @Override
    public CrailKeyValue asKeyValue() throws Exception {
        return this;
    }

    @Override
    public CrailStore getFileSystem() {
        return this.fs;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public CrailNode syncDir() throws Exception {
        return this.file().syncDir();
    }

    @Override
    public long getModificationTime() {
        return this.file().getModificationTime();
    }

    @Override
    public long getCapacity() {
        return this.file().getCapacity();
    }

    @Override
    public CrailNodeType getType() {
        return this.type;
    }

    @Override
    public CrailContainer asContainer() throws Exception {
        throw new Exception("this is not a container");
    }

    @Override
    public CrailDirectory asDirectory() throws Exception {
        throw new Exception("this is not a directory");
    }

    @Override
    public CrailMultiFile asMultiFile() throws Exception {
        throw new Exception("this is not a multifile");
    }

    @Override
    public CrailTable asTable() throws Exception {
        throw new Exception("this is not a table");
    }

    @Override
    public long getFd() {
        return this.file().getFd();
    }

    private synchronized CrailFile file() {
        try {
            if (this.file == null) {
                this.file = ((CrailNode)this.future.get()).asFile();
            }
            return this.file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

