/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailStatistics;

public class CoreIOStatistics
implements CrailStatistics.StatisticsProvider {
    private String mode;
    private AtomicLong totalOps;
    private AtomicLong localOps;
    private AtomicLong remoteOps;
    private AtomicLong localDirOps;
    private AtomicLong remoteDirOps;
    private AtomicLong cachedOps;
    private AtomicLong nonblockingOps;
    private AtomicLong blockingOps;
    private AtomicLong prefetchedOps;
    private AtomicLong prefetchedBlockingOps;
    private AtomicLong prefetchedNonblockingOps;
    private AtomicLong opLen;
    private AtomicLong capacity;
    private AtomicLong totalStreams;
    private AtomicLong totalSeeks;

    public CoreIOStatistics(String mode) {
        this.mode = mode;
        this.totalOps = new AtomicLong(0L);
        this.localOps = new AtomicLong(0L);
        this.remoteOps = new AtomicLong(0L);
        this.localDirOps = new AtomicLong(0L);
        this.remoteDirOps = new AtomicLong(0L);
        this.cachedOps = new AtomicLong(0L);
        this.nonblockingOps = new AtomicLong(0L);
        this.blockingOps = new AtomicLong(0L);
        this.prefetchedOps = new AtomicLong(0L);
        this.prefetchedBlockingOps = new AtomicLong(0L);
        this.prefetchedNonblockingOps = new AtomicLong(0L);
        this.opLen = new AtomicLong(0L);
        this.capacity = new AtomicLong(0L);
        this.totalStreams = new AtomicLong(0L);
        this.totalSeeks = new AtomicLong(0L);
        this.resetStatistics();
    }

    @Override
    public String providerName() {
        return this.mode;
    }

    @Override
    public String printStatistics() {
        return "total " + this.getTotalOps() + ", localOps " + this.getLocalOps() + ", remoteOps " + this.getRemoteOps() + ", localDirOps " + this.getLocalDirOps() + ", remoteDirOps " + this.getRemoteDirOps() + ", cached " + this.getCachedOps() + ", nonBlocking " + this.getNonblockingOps() + ", blocking " + this.getBlockingOps() + ", prefetched " + this.getPrefetchedOps() + ", prefetchedNonBlocking " + this.getPrefetchedNonblockingOps() + ", prefetchedBlocking " + this.getPrefetchedBlockingOps() + ", capacity " + this.getCapacity() + ", totalStreams " + this.getTotalStreams() + ", avgCapacity " + this.getAvgCapacity() + ", avgOpLen " + this.getAvgOpLen();
    }

    @Override
    public void resetStatistics() {
        this.totalOps.set(0L);
        this.localOps.set(0L);
        this.remoteOps.set(0L);
        this.localDirOps.set(0L);
        this.remoteDirOps.set(0L);
        this.cachedOps.set(0L);
        this.nonblockingOps.set(0L);
        this.blockingOps.set(0L);
        this.prefetchedOps.set(0L);
        this.prefetchedBlockingOps.set(0L);
        this.prefetchedNonblockingOps.set(0L);
        this.opLen.set(0L);
        this.capacity.set(0L);
        this.totalStreams.set(0L);
        this.totalSeeks.set(0L);
    }

    @Override
    public void mergeStatistics(CrailStatistics.StatisticsProvider provider) {
        if (provider instanceof CoreIOStatistics) {
            CoreIOStatistics newProvider = (CoreIOStatistics)provider;
            this.totalOps.addAndGet(newProvider.getTotalOps());
            this.localOps.addAndGet(newProvider.getLocalOps());
            this.remoteOps.addAndGet(newProvider.getRemoteOps());
            this.localDirOps.addAndGet(newProvider.getLocalDirOps());
            this.remoteDirOps.addAndGet(newProvider.getRemoteDirOps());
            this.cachedOps.addAndGet(newProvider.getCachedOps());
            this.nonblockingOps.addAndGet(newProvider.getNonblockingOps());
            this.blockingOps.addAndGet(newProvider.getBlockingOps());
            this.prefetchedOps.addAndGet(newProvider.getPrefetchedOps());
            this.prefetchedNonblockingOps.addAndGet(newProvider.getPrefetchedNonblockingOps());
            this.prefetchedBlockingOps.addAndGet(newProvider.getPrefetchedBlockingOps());
            this.opLen.addAndGet(newProvider.getOpLen());
            this.capacity.addAndGet(newProvider.getCapacity());
            this.totalSeeks.addAndGet(newProvider.getTotalSeeks());
            this.totalStreams.incrementAndGet();
        }
    }

    public long getTotalOps() {
        return this.totalOps.get();
    }

    void incTotalOps(long opLen) {
        this.totalOps.incrementAndGet();
        this.opLen.addAndGet(opLen);
    }

    public long getLocalOps() {
        return this.localOps.get();
    }

    public void incLocalOps() {
        this.localOps.incrementAndGet();
    }

    public long getRemoteOps() {
        return this.remoteOps.get();
    }

    public void incRemoteOps() {
        this.remoteOps.incrementAndGet();
    }

    public long getLocalDirOps() {
        return this.localDirOps.get();
    }

    public void incLocalDirOps() {
        this.localDirOps.incrementAndGet();
    }

    public long getRemoteDirOps() {
        return this.remoteDirOps.get();
    }

    public void incRemoteDirOps() {
        this.remoteDirOps.incrementAndGet();
    }

    public long getCachedOps() {
        return this.cachedOps.get();
    }

    void incCachedOps() {
        this.cachedOps.incrementAndGet();
    }

    public long getNonblockingOps() {
        return this.nonblockingOps.get();
    }

    void incNonblockingOps() {
        this.nonblockingOps.incrementAndGet();
    }

    public long getBlockingOps() {
        return this.blockingOps.get();
    }

    void incBlockingOps() {
        this.blockingOps.incrementAndGet();
    }

    public long getPrefetchedOps() {
        return this.prefetchedOps.get();
    }

    void incPrefetchedOps() {
        this.prefetchedOps.incrementAndGet();
    }

    public long getPrefetchedBlockingOps() {
        return this.prefetchedBlockingOps.get();
    }

    void incPrefetchedBlockingOps() {
        this.prefetchedBlockingOps.incrementAndGet();
    }

    public long getPrefetchedNonblockingOps() {
        return this.prefetchedNonblockingOps.get();
    }

    void incPrefetchedNonblockingOps() {
        this.prefetchedNonblockingOps.incrementAndGet();
    }

    public long getOpLen() {
        return this.opLen.get();
    }

    public long getAvgOpLen() {
        long _avg = 0L;
        long _totalOps = this.totalOps.get();
        long _opLen = this.opLen.get();
        if (_totalOps > 0L) {
            _avg = _opLen / _totalOps;
        }
        return _avg;
    }

    public void setCapacity(long capacity) {
        this.capacity.set(capacity);
    }

    public long getCapacity() {
        return this.capacity.get();
    }

    public long getAvgCapacity() {
        long _avg = 0L;
        long _capacity = this.capacity.get();
        long _totalStreams = this.totalStreams.get();
        if (_totalStreams > 0L) {
            _avg = _capacity / _totalStreams;
        }
        return _avg;
    }

    public long getTotalStreams() {
        return this.totalStreams.get();
    }

    public long getTotalSeeks() {
        return this.totalSeeks.get();
    }

    void incTotalSeekds() {
        this.totalSeeks.incrementAndGet();
    }
}

