/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.crail.Upcoming;
import org.apache.crail.conf.CrailConstants;

public abstract class CoreMetaDataOperation<R, T>
implements Upcoming<T> {
    protected static int RPC_PENDING = 0;
    protected static int RPC_DONE = 1;
    protected static int RPC_ERROR = 2;
    private AtomicInteger status;
    protected Future<R> rpcResult;
    private T finalResult;
    private Exception exception;

    abstract T process(R var1) throws Exception;

    public CoreMetaDataOperation(Future<R> result) {
        this.rpcResult = result;
        this.finalResult = null;
        this.status = new AtomicInteger(RPC_PENDING);
        this.exception = null;
    }

    @Override
    public boolean isDone() {
        if (this.status.get() == RPC_PENDING) {
            try {
                if (this.rpcResult.isDone()) {
                    R tmp = this.rpcResult.get();
                    this.finalResult = this.process(tmp);
                    this.status.set(RPC_DONE);
                }
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                this.exception = e;
            }
        }
        return this.status.get() > 0;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.status.get() == RPC_PENDING) {
            try {
                R tmp = this.rpcResult.get();
                this.finalResult = this.process(tmp);
                this.status.set(RPC_DONE);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                this.exception = e;
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this.finalResult;
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        throw new InterruptedException("RPC error");
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.status.get() == RPC_PENDING) {
            try {
                R tmp = this.rpcResult.get(CrailConstants.DATA_TIMEOUT, TimeUnit.MILLISECONDS);
                this.finalResult = this.process(tmp);
                this.status.set(RPC_DONE);
            }
            catch (Exception e) {
                this.status.set(RPC_ERROR);
                this.exception = e;
            }
        }
        if (this.status.get() == RPC_DONE) {
            return this.finalResult;
        }
        if (this.status.get() == RPC_PENDING) {
            throw new InterruptedException("RPC timeout");
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        throw new InterruptedException("RPC error");
    }

    @Override
    public T early() throws Exception {
        return this.get();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

