/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.crail.CrailBlockLocation;
import org.apache.crail.CrailKeyValue;
import org.apache.crail.CrailMultiFile;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailTable;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreDirectory;
import org.apache.crail.core.CoreFile;
import org.apache.crail.core.CoreInputStream;
import org.apache.crail.core.CoreOutputStream;
import org.apache.crail.core.CoreSyncOperation;
import org.apache.crail.metadata.FileInfo;

public class CoreNode
implements CrailNode {
    protected CoreDataStore fs;
    protected FileInfo fileInfo;
    protected String path;
    private LinkedBlockingQueue<CoreSyncOperation> syncOperations;

    public static CoreNode create(CoreDataStore fs, FileInfo fileInfo, String path) {
        if (fileInfo.getType().isContainer()) {
            return new CoreDirectory(fs, fileInfo, path);
        }
        return new CoreFile(fs, fileInfo, path);
    }

    protected CoreNode(CoreDataStore fs, FileInfo fileInfo, String path) {
        this.fs = fs;
        this.fileInfo = fileInfo;
        this.path = path;
        this.syncOperations = new LinkedBlockingQueue();
    }

    @Override
    public CoreDataStore getFileSystem() {
        return this.fs;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getModificationTime() {
        return this.fileInfo.getModificationTime();
    }

    @Override
    public long getCapacity() {
        return this.fileInfo.getCapacity();
    }

    @Override
    public CrailNodeType getType() {
        return this.fileInfo.getType();
    }

    public long getFd() {
        return this.fileInfo.getFd();
    }

    @Override
    public CoreNode syncDir() throws Exception {
        while (!this.syncOperations.isEmpty()) {
            CoreSyncOperation syncOp = this.syncOperations.poll();
            syncOp.close();
        }
        return this;
    }

    @Override
    public CoreFile asFile() throws Exception {
        throw new Exception("Type of file unclear");
    }

    @Override
    public CoreDirectory asContainer() throws Exception {
        throw new Exception("Type of file unclear");
    }

    @Override
    public CoreDirectory asDirectory() throws Exception {
        throw new Exception("Type of file unclear");
    }

    @Override
    public CrailMultiFile asMultiFile() throws Exception {
        throw new Exception("Type of file unclear");
    }

    @Override
    public CrailTable asTable() throws Exception {
        throw new Exception("Type of file unclear");
    }

    @Override
    public CrailKeyValue asKeyValue() throws Exception {
        throw new Exception("Type of file unclear");
    }

    @Override
    public CrailBlockLocation[] getBlockLocations(long start, long len) throws Exception {
        return this.fs.getBlockLocations(this.path, start, len);
    }

    protected CoreInputStream getInputStream(long readHint) throws Exception {
        return this.fs.getInputStream(this, readHint);
    }

    CoreOutputStream getOutputStream(long writeHint) throws Exception {
        return this.fs.getOutputStream(this, writeHint);
    }

    void closeInputStream(CoreInputStream coreStream) throws Exception {
        this.fs.unregisterInputStream(coreStream);
    }

    void closeOutputStream(CoreOutputStream coreStream) throws Exception {
        this.syncDir();
        this.fs.unregisterOutputStream(coreStream);
    }

    FileInfo getFileInfo() {
        return this.fileInfo;
    }

    void addSyncOperation(CoreSyncOperation operation) {
        this.syncOperations.add(operation);
    }
}

