/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailOutputStream;
import org.apache.crail.CrailResult;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataOperation;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.CoreStream;
import org.apache.crail.core.CoreSubOperation;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.storage.StorageEndpoint;
import org.apache.crail.storage.StorageFuture;
import org.apache.crail.utils.CrailImmediateOperation;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class CoreOutputStream
extends CoreStream
implements CrailOutputStream {
    private static final Logger LOG = CrailUtils.getLogger();
    private AtomicLong inFlight;
    private long writeHint;
    private CrailImmediateOperation noOp;
    private boolean open;

    public CoreOutputStream(CoreNode file, long streamId, long writeHint) throws Exception {
        super(file, streamId, file.getCapacity());
        this.writeHint = Math.max(0L, writeHint);
        this.inFlight = new AtomicLong(0L);
        this.noOp = new CrailImmediateOperation(0);
        this.open = true;
        if (CrailConstants.DEBUG) {
            LOG.info("CoreOutputStream, open, path " + file.getPath() + ", fd " + file.getFd() + ", streamId " + streamId + ", isDir " + file.getType().isDirectory() + ", writeHint " + this.writeHint);
        }
    }

    @Override
    public final Future<CrailResult> write(CrailBuffer dataBuf) throws Exception {
        if (!this.open) {
            throw new IOException("Stream closed, cannot write");
        }
        if (dataBuf.remaining() <= 0) {
            return this.noOp;
        }
        this.inFlight.incrementAndGet();
        CoreDataOperation future = this.dataOperation(dataBuf);
        if (this.position() < this.writeHint) {
            this.prefetchMetadata();
        }
        if (future.isSynchronous()) {
            future.get();
        }
        return future;
    }

    @Override
    public final long getWriteHint() {
        return this.writeHint;
    }

    @Override
    public Future<Void> sync() throws IOException {
        if (this.inFlight.get() != 0L) {
            LOG.info("Cannot sync, pending operations, opcount " + this.inFlight.get());
            throw new IOException("Cannot close, pending operations, opcount " + this.inFlight.get());
        }
        return super.sync();
    }

    @Override
    public void close() throws Exception {
        if (!this.open) {
            return;
        }
        if (this.inFlight.get() != 0L) {
            LOG.info("Cannot close, pending operations, opcount " + this.inFlight.get() + ", path " + ((CoreNode)this.getFile()).getPath());
            throw new IOException("Cannot close, pending operations, opcount " + this.inFlight.get() + ", fd " + ((CoreNode)this.getFile()).getFd() + ", streamId " + this.getStreamId() + ", capacity " + ((CoreNode)this.getFile()).getCapacity());
        }
        this.sync().get();
        this.updateIOStats();
        this.node.closeOutputStream(this);
        this.open = false;
        if (CrailConstants.DEBUG) {
            LOG.info("CoreOutputStream, close, path " + ((CoreNode)this.getFile()).getPath() + ", fd " + ((CoreNode)this.getFile()).getFd() + ", streamId " + this.getStreamId() + ", capacity " + ((CoreNode)this.getFile()).getCapacity());
        }
    }

    @Override
    StorageFuture trigger(StorageEndpoint endpoint, CoreSubOperation opDesc, CrailBuffer buffer, BlockInfo block) throws Exception {
        StorageFuture dataFuture = endpoint.write(buffer, block, opDesc.getBlockOffset());
        return dataFuture;
    }

    @Override
    synchronized void update(long newCapacity) {
        this.inFlight.decrementAndGet();
        this.setCapacity(newCapacity);
    }
}

