/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailResult;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.CoreInputStream;
import org.apache.crail.core.CoreNode;
import org.apache.crail.core.DirectoryRecord;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DirectoryInputStream
implements Iterator<String> {
    private static final Logger LOG = CrailUtils.getLogger();
    private CoreInputStream stream;
    private CrailBuffer internalBuf;
    private CoreDataStore fs;
    private String parent;
    private String currentFile;
    private int consumedRecords;
    private int availableRecords;
    private int[] blockTickets;
    private Random random;
    private boolean randomize;
    private boolean open;

    public DirectoryInputStream(CoreInputStream stream, boolean randomize) throws Exception {
        this.stream = stream;
        this.randomize = randomize;
        this.fs = ((CoreNode)stream.getFile()).getFileSystem();
        this.parent = ((CoreNode)stream.getFile()).getPath();
        this.internalBuf = this.fs.allocateBuffer();
        this.internalBuf.clear();
        this.internalBuf.position(this.internalBuf.capacity());
        this.currentFile = null;
        this.availableRecords = 0;
        this.consumedRecords = 0;
        this.random = new Random();
        this.blockTickets = new int[CrailConstants.BUFFER_SIZE / CrailConstants.DIRECTORY_RECORD];
        for (int i = 0; i < this.blockTickets.length; ++i) {
            this.blockTickets[i] = i;
        }
        this.open = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        if (this.currentFile != null) {
            return true;
        }
        while (this.hasRecord()) {
            DirectoryRecord record = this.nextRecord();
            if (!record.isValid()) continue;
            this.currentFile = CrailUtils.combinePath(record.getParent(), record.getFile());
            break;
        }
        return this.currentFile != null;
    }

    @Override
    public String next() {
        if (!this.open) {
            return null;
        }
        String ret = this.currentFile;
        this.currentFile = null;
        return ret;
    }

    public boolean hasRecord() {
        if (!this.open) {
            return false;
        }
        if (this.fetchIfEmpty() > 0) {
            return true;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.info("error when closing directory stream " + e.getMessage());
        }
        return false;
    }

    public DirectoryRecord nextRecord() {
        if (!this.open) {
            return null;
        }
        DirectoryRecord record = new DirectoryRecord(this.parent);
        int offset = this.blockTickets[this.consumedRecords] * CrailConstants.DIRECTORY_RECORD;
        this.internalBuf.position(offset);
        record.update(this.internalBuf);
        ++this.consumedRecords;
        return record;
    }

    private int fetchIfEmpty() {
        try {
            if (this.consumedRecords == this.availableRecords) {
                long ret;
                this.internalBuf.clear();
                Future<CrailResult> future = this.stream.read(this.internalBuf);
                if (future != null && (ret = future.get(CrailConstants.DATA_TIMEOUT, TimeUnit.MILLISECONDS).getLen()) > 0L) {
                    this.internalBuf.flip();
                    this.availableRecords = this.internalBuf.remaining() / CrailConstants.DIRECTORY_RECORD;
                    this.consumedRecords = 0;
                    if (this.randomize) {
                        this.shuffleTickets(this.blockTickets, this.availableRecords);
                    }
                }
            }
            return this.availableRecords - this.consumedRecords;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void close() throws IOException {
        try {
            if (!this.open) {
                return;
            }
            this.stream.close();
            this.fs.freeBuffer(this.internalBuf);
            this.internalBuf = null;
            this.open = false;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    void shuffleTickets(int[] tickets, int length) {
        int i;
        for (i = 0; i < this.availableRecords; ++i) {
            this.blockTickets[i] = i;
        }
        for (i = length - 1; i > 0; --i) {
            int index = this.random.nextInt(i + 1);
            int tmp = tickets[index];
            tickets[index] = tickets[i];
            tickets[i] = tmp;
        }
    }
}

