/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.core;

import org.apache.crail.CrailBuffer;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.utils.CrailUtils;

public class DirectoryRecord {
    private int valid;
    private String parent;
    private String filename;

    public DirectoryRecord(boolean valid, String path) {
        this.valid = valid ? 1 : 0;
        this.parent = CrailUtils.getParent(path);
        this.filename = CrailUtils.getName(path);
    }

    public DirectoryRecord(String parent) {
        this.valid = 0;
        this.parent = parent;
        this.filename = null;
    }

    public void write(CrailBuffer buffer) throws Exception {
        int oldposition = buffer.position();
        buffer.putInt(this.valid);
        byte[] barray = this.filename.getBytes();
        buffer.putInt(barray.length);
        buffer.put(barray);
        buffer.position(oldposition + CrailConstants.DIRECTORY_RECORD);
    }

    public void update(CrailBuffer buffer) {
        int oldlimit = buffer.limit();
        int tmplimit = buffer.position() + CrailConstants.DIRECTORY_RECORD;
        buffer.limit(tmplimit);
        this.valid = buffer.getInt();
        int length = buffer.getInt();
        byte[] barray = new byte[length];
        buffer.get(barray);
        this.filename = new String(barray);
        buffer.position(tmplimit);
        buffer.limit(oldlimit);
    }

    public boolean isValid() {
        return this.valid == 1;
    }

    public String toString() {
        return this.valid + "\t\t" + this.filename;
    }

    public String getFile() {
        return this.filename;
    }

    public String getParent() {
        return this.parent;
    }
}

