/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.memory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailBuffer;
import org.apache.crail.CrailBufferCache;
import org.apache.crail.CrailStatistics;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.memory.OffHeapBuffer;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public abstract class BufferCache
implements CrailStatistics.StatisticsProvider,
CrailBufferCache {
    private static final Logger LOG = CrailUtils.getLogger();
    private LinkedBlockingQueue<CrailBuffer> cache = new LinkedBlockingQueue();
    private AtomicLong cacheGet = new AtomicLong(0L);
    private AtomicLong cachePut = new AtomicLong(0L);
    private AtomicLong cacheMisses = new AtomicLong(0L);
    private AtomicLong cacheOut = new AtomicLong(0L);
    private AtomicLong cacheMax = new AtomicLong(0L);
    private AtomicLong cacheMissesMap = new AtomicLong(0L);
    private AtomicLong cacheMissesHeap = new AtomicLong(0L);

    public abstract CrailBuffer allocateRegion() throws IOException;

    @Override
    public String providerName() {
        return "cache/buffer";
    }

    @Override
    public String printStatistics() {
        return "cacheGet " + this.cacheGet.get() + ", cachePut " + this.cachePut.get() + ", cacheMiss " + this.cacheMisses.get() + ", cacheSize " + this.cache.size() + ", cacheMax " + this.cacheMax.get() + ", mapMiss " + this.cacheMissesMap.get() + ", mapHeap " + this.cacheMissesHeap.get();
    }

    @Override
    public void resetStatistics() {
        this.cacheGet.set(0L);
        this.cachePut.set(0L);
        this.cacheMisses.set(0L);
        this.cacheOut.set(0L);
        this.cacheMax.set(0L);
        this.cacheMissesMap.set(0L);
        this.cacheMissesHeap.set(0L);
    }

    @Override
    public void mergeStatistics(CrailStatistics.StatisticsProvider provider) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrailBuffer allocateBuffer() throws IOException {
        this.cacheGet.incrementAndGet();
        this.cacheOut.incrementAndGet();
        this.cacheMax.updateAndGet(x -> Math.max(x, this.cacheOut.get()));
        CrailBuffer buffer = this.cache.poll();
        if (buffer == null) {
            BufferCache bufferCache = this;
            synchronized (bufferCache) {
                buffer = this.cache.poll();
                if (buffer == null) {
                    this.cacheMisses.incrementAndGet();
                    buffer = this.allocateRegion();
                    if (buffer == null) {
                        buffer = OffHeapBuffer.wrap(ByteBuffer.allocateDirect(CrailConstants.BUFFER_SIZE));
                        this.cacheMissesHeap.incrementAndGet();
                    } else {
                        this.cacheMissesMap.incrementAndGet();
                    }
                }
            }
        }
        buffer.clear();
        return buffer;
    }

    @Override
    public void freeBuffer(CrailBuffer buffer) throws IOException {
        if (buffer != null) {
            this.cachePut.incrementAndGet();
            this.cacheOut.decrementAndGet();
            this.putBufferInternal(buffer);
        }
    }

    public void putBufferInternal(CrailBuffer buffer) throws IOException {
        this.cache.add(buffer);
    }

    public void close() {
        this.cache.clear();
    }

    public static BufferCache createInstance(String name) throws Exception {
        Class<?> nodeClass = Class.forName(name);
        if (BufferCache.class.isAssignableFrom(nodeClass)) {
            Class<?> bufferCacheClass = nodeClass;
            BufferCache bufferCache = (BufferCache)bufferCacheClass.newInstance();
            return bufferCache;
        }
        throw new Exception("Cannot instantiate storage client of type " + name);
    }
}

