/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.memory;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.crail.CrailBuffer;
import org.apache.crail.utils.CrailUtils;
import sun.nio.ch.DirectBuffer;

public class OffHeapBuffer
implements CrailBuffer {
    private CrailBuffer region;
    private ByteBuffer buffer;
    private long address;

    OffHeapBuffer(ByteBuffer buffer) {
        this.region = this;
        this.buffer = buffer;
        this.address = CrailUtils.getAddress(buffer);
    }

    OffHeapBuffer(CrailBuffer region, ByteBuffer buffer) {
        this.region = region;
        this.buffer = buffer;
        this.address = CrailUtils.getAddress(buffer);
    }

    public static OffHeapBuffer wrap(ByteBuffer buffer) throws IOException {
        if (!(buffer instanceof DirectBuffer)) {
            throw new IOException("buffer not offheap");
        }
        return new OffHeapBuffer(buffer);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public CrailBuffer position(int newPosition) {
        this.buffer.position(newPosition);
        return this;
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public CrailBuffer limit(int newLimit) {
        this.buffer.limit(newLimit);
        return this;
    }

    @Override
    public CrailBuffer clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public CrailBuffer flip() {
        this.buffer.flip();
        return this;
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public CrailBuffer slice() {
        try {
            ByteBuffer slice = this.buffer.slice();
            return new OffHeapBuffer(this.region, slice);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public CrailBuffer getRegion() {
        return this.region;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public ByteBuffer put(byte b) {
        return this.buffer.put(b);
    }

    @Override
    public CrailBuffer get(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    @Override
    public CrailBuffer put(byte[] src, int offset, int length) {
        this.buffer.put(src, offset, length);
        return this;
    }

    @Override
    public CrailBuffer get(byte[] bytes) {
        this.buffer.get(bytes);
        return this;
    }

    @Override
    public CrailBuffer put(byte[] bytes) {
        this.buffer.put(bytes);
        return this;
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public CrailBuffer putShort(short value) {
        this.buffer.putShort(value);
        return this;
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public CrailBuffer putInt(int value) {
        this.buffer.putInt(value);
        return this;
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public CrailBuffer putLong(long value) {
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public CrailBuffer putFloat(float value) {
        this.buffer.putFloat(value);
        return this;
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public CrailBuffer putDouble(double value) {
        this.buffer.putDouble(value);
        return this;
    }

    @Override
    public CrailBuffer put(ByteBuffer src) {
        this.buffer.put(src);
        return this;
    }

    @Override
    public CrailBuffer get(ByteBuffer dst) {
        dst.put(this.buffer);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

