/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.metadata;

import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DataNodeInfo {
    private static final Logger LOG = CrailUtils.getLogger();
    public static final int CSIZE = 20;
    private int storageType = 0;
    private int storageClass = 0;
    private int locationClass = 0;
    private byte[] ipAddress = new byte[4];
    private int port = 0;
    private long key = 0L;

    public DataNodeInfo() {
    }

    public DataNodeInfo(int storageType, int storageClass, int locationClass, byte[] ipAddress, int port) {
        this();
        this.storageType = storageType;
        this.storageClass = storageClass;
        this.locationClass = locationClass;
        for (int i = 0; i < ipAddress.length; ++i) {
            this.ipAddress[i] = ipAddress[i];
        }
        this.port = port;
    }

    void setDataNodeInfo(DataNodeInfo info) {
        this.storageType = info.getStorageType();
        this.storageClass = info.getStorageClass();
        this.locationClass = info.getLocationClass();
        for (int i = 0; i < this.ipAddress.length; ++i) {
            this.ipAddress[i] = info.getIpAddress()[i];
        }
        this.port = info.getPort();
        this.key = 0L;
    }

    public int write(ByteBuffer buffer) {
        buffer.putInt(this.storageType);
        buffer.putInt(this.storageClass);
        buffer.putInt(this.locationClass);
        buffer.put(this.ipAddress);
        buffer.putInt(this.port);
        return 20;
    }

    public void update(ByteBuffer buffer) throws UnknownHostException {
        this.storageType = buffer.getInt();
        this.storageClass = buffer.getInt();
        this.locationClass = buffer.getInt();
        buffer.get(this.ipAddress);
        this.port = buffer.getInt();
        this.key = 0L;
    }

    public byte[] getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public int getLocationClass() {
        return this.locationClass;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public int getStorageClass() {
        return this.storageClass;
    }

    public long key() {
        if (this.key == 0L) {
            int a = Arrays.hashCode(this.ipAddress);
            this.key = (long)a << 32 | (long)this.port & 0xFFFFFFFFL;
        }
        return this.key;
    }

    public String toString() {
        return "DataNodeInfo [storageType=" + this.storageType + ", storageClass=" + this.storageClass + ", locationClass=" + this.locationClass + ", ipAddress=" + Arrays.toString(this.ipAddress) + ", port=" + this.port + ", key=" + this.key() + "]";
    }
}

