/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.apache.crail.conf.CrailConstants;

public class FileName {
    public static int CSIZE = 4 + CrailConstants.DIRECTORY_DEPTH * 4;
    private int length = 0;
    private int[] components = new int[CrailConstants.DIRECTORY_DEPTH];

    public FileName() {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = 0;
        }
    }

    public FileName(String name) throws IOException {
        this();
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        if (tokenizer.countTokens() > this.components.length) {
            throw new IOException("filename with too many tokens, filename " + name + ", tokens " + this.components.length);
        }
        this.length = tokenizer.countTokens();
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            this.components[i] = token.hashCode();
            ++i;
        }
    }

    public FileName(FileName name) {
        this();
        this.length = name.length;
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = name.components[i];
        }
    }

    public int write(ByteBuffer buffer) {
        buffer.putInt(this.length);
        int written = 4;
        for (int i = 0; i < this.components.length; ++i) {
            buffer.putInt(this.components[i]);
            written += 4;
        }
        return written;
    }

    public void update(ByteBuffer buffer) {
        this.length = buffer.getInt();
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = buffer.getInt();
        }
    }

    public int getFileComponent() {
        return this.getComponent(this.length - 1);
    }

    public int getComponent(int index) {
        if (index >= 0 && index < this.components.length) {
            return this.components[index];
        }
        return 0;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return CSIZE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileName other = (FileName)obj;
        return this.hashCode() == other.hashCode();
    }

    public String toString() {
        String tmp = "components=/";
        for (int i = 0; i < this.components.length; ++i) {
            tmp = tmp + this.components[i] + "/";
        }
        tmp = tmp + ", length=" + this.length;
        return tmp;
    }
}

