/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.rpc;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.crail.CrailNodeType;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.metadata.FileName;
import org.apache.crail.rpc.RpcConnection;
import org.apache.crail.rpc.RpcCreateFile;
import org.apache.crail.rpc.RpcDeleteFile;
import org.apache.crail.rpc.RpcFuture;
import org.apache.crail.rpc.RpcGetBlock;
import org.apache.crail.rpc.RpcGetDataNode;
import org.apache.crail.rpc.RpcGetFile;
import org.apache.crail.rpc.RpcGetLocation;
import org.apache.crail.rpc.RpcPing;
import org.apache.crail.rpc.RpcRenameFile;
import org.apache.crail.rpc.RpcVoid;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class RpcDispatcher
implements RpcConnection {
    private static final Logger LOG = CrailUtils.getLogger();
    private RpcConnection[] connections;
    private int setBlockIndex;
    private int getDataNodeIndex;

    public RpcDispatcher(ConcurrentLinkedQueue<RpcConnection> connectionList) {
        this.connections = new RpcConnection[connectionList.size()];
        for (int i = 0; i < this.connections.length; ++i) {
            this.connections[i] = connectionList.poll();
        }
        this.setBlockIndex = 0;
        this.getDataNodeIndex = 0;
    }

    @Override
    public RpcFuture<RpcCreateFile> createFile(FileName filename, CrailNodeType type, int storageClass, int locationClass, boolean enumerable) throws IOException {
        int index = this.computeIndex(filename.getComponent(0));
        return this.connections[index].createFile(filename, type, storageClass, locationClass, enumerable);
    }

    @Override
    public RpcFuture<RpcGetFile> getFile(FileName filename, boolean writeable) throws IOException {
        int index = this.computeIndex(filename.getComponent(0));
        return this.connections[index].getFile(filename, writeable);
    }

    @Override
    public RpcFuture<RpcVoid> setFile(FileInfo fileInfo, boolean close) throws IOException {
        int index = this.computeIndex(fileInfo.getFd());
        return this.connections[index].setFile(fileInfo, close);
    }

    @Override
    public RpcFuture<RpcDeleteFile> removeFile(FileName filename, boolean recursive) throws IOException {
        int index = this.computeIndex(filename.getComponent(0));
        return this.connections[index].removeFile(filename, recursive);
    }

    @Override
    public RpcFuture<RpcRenameFile> renameFile(FileName srcHash, FileName dstHash) throws IOException {
        int dstIndex;
        int srcIndex = this.computeIndex(srcHash.getComponent(0));
        if (srcIndex != (dstIndex = this.computeIndex(srcHash.getComponent(0)))) {
            throw new IOException("Rename not supported across namenode domains");
        }
        return this.connections[srcIndex].renameFile(srcHash, dstHash);
    }

    @Override
    public RpcFuture<RpcGetBlock> getBlock(long fd, long token, long position, long capacity) throws IOException {
        int index = this.computeIndex(fd);
        return this.connections[index].getBlock(fd, token, position, capacity);
    }

    @Override
    public RpcFuture<RpcGetLocation> getLocation(FileName fileName, long position) throws IOException {
        int index = this.computeIndex(fileName.getComponent(0));
        return this.connections[index].getLocation(fileName, position);
    }

    @Override
    public RpcFuture<RpcVoid> setBlock(BlockInfo blockInfo) throws Exception {
        RpcFuture<RpcVoid> res = this.connections[this.setBlockIndex].setBlock(blockInfo);
        this.setBlockIndex = (this.setBlockIndex + 1) % this.connections.length;
        return res;
    }

    @Override
    public RpcFuture<RpcGetDataNode> getDataNode(DataNodeInfo dnInfo) throws Exception {
        RpcFuture<RpcGetDataNode> res = this.connections[this.getDataNodeIndex].getDataNode(dnInfo);
        this.getDataNodeIndex = (this.getDataNodeIndex + 1) % this.connections.length;
        return res;
    }

    @Override
    public RpcFuture<RpcVoid> dumpNameNode() throws Exception {
        return this.connections[0].dumpNameNode();
    }

    @Override
    public RpcFuture<RpcPing> pingNameNode() throws Exception {
        return this.connections[0].pingNameNode();
    }

    @Override
    public void close() throws Exception {
        for (RpcConnection connection : this.connections) {
            connection.close();
        }
    }

    public String toString() {
        String address = "";
        for (RpcConnection connection : this.connections) {
            address = address + ", " + connection.toString();
        }
        return address;
    }

    private int computeIndex(int component) {
        int index = (component % this.connections.length + this.connections.length) % this.connections.length;
        return index;
    }

    private int computeIndex(long component) {
        long connectionsLength = this.connections.length;
        long _index = (component % connectionsLength + connectionsLength) % connectionsLength;
        int index = (int)_index;
        return index;
    }
}

