/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.crail.CrailBlockLocation;
import org.apache.crail.CrailDirectory;
import org.apache.crail.CrailFile;
import org.apache.crail.CrailLocationClass;
import org.apache.crail.CrailMultiFile;
import org.apache.crail.CrailNode;
import org.apache.crail.CrailNodeType;
import org.apache.crail.CrailStorageClass;
import org.apache.crail.CrailStore;
import org.apache.crail.conf.CrailConfiguration;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.core.CoreDataStore;
import org.apache.crail.core.DirectoryInputStream;
import org.apache.crail.core.DirectoryRecord;
import org.apache.crail.metadata.FileName;
import org.apache.crail.utils.CrailUtils;

public class CrailFsck {
    public void getLocations(String filename, long offset, long length) throws Exception {
        System.out.println("getLocations, filename " + filename + ", offset " + offset + ", len " + length);
        CrailConfiguration conf = new CrailConfiguration();
        CrailStore fs = CrailStore.newInstance(conf);
        CrailBlockLocation[] locations = ((CrailNode)fs.lookup(filename).get()).getBlockLocations(offset, length);
        for (int i = 0; i < locations.length; ++i) {
            System.out.println("location " + i + " : " + locations[i].toString());
        }
        fs.close();
    }

    public void blockStatistics(String filename) throws Exception {
        HashMap<String, AtomicInteger> stats = new HashMap<String, AtomicInteger>();
        CrailConfiguration conf = new CrailConfiguration();
        CrailStore fs = CrailStore.newInstance(conf);
        CrailNode node = (CrailNode)fs.lookup(filename).get();
        if (node.getType() == CrailNodeType.DIRECTORY) {
            CrailDirectory directory = node.asDirectory();
            Iterator<String> iter = directory.listEntries();
            while (iter.hasNext()) {
                String path = iter.next();
                CrailFile child = ((CrailNode)fs.lookup(path).get()).asFile();
                this.walkBlocks(stats, fs, child.getPath(), 0L, child.getCapacity());
            }
        } else if (node.getType() == CrailNodeType.DATAFILE) {
            CrailFile file = node.asFile();
            this.walkBlocks(stats, fs, file.getPath(), 0L, file.getCapacity());
        } else if (node.getType() == CrailNodeType.MULTIFILE) {
            CrailMultiFile directory = node.asMultiFile();
            Iterator<String> iter = directory.listEntries();
            while (iter.hasNext()) {
                String path = iter.next();
                CrailFile child = ((CrailNode)fs.lookup(path).get()).asFile();
                this.walkBlocks(stats, fs, child.getPath(), 0L, child.getCapacity());
            }
        }
        this.printStats(stats);
        fs.close();
    }

    public void namenodeDump() throws Exception {
        CrailConfiguration conf = new CrailConfiguration();
        CoreDataStore fs = new CoreDataStore(conf);
        fs.dumpNameNode();
        fs.close();
    }

    public void directoryDump(String filename, boolean randomize) throws Exception {
        CrailConfiguration conf = new CrailConfiguration();
        CrailConstants.updateConstants(conf);
        CoreDataStore fs = new CoreDataStore(conf);
        DirectoryInputStream iter = fs._listEntries(filename, randomize);
        System.out.println("#hash   \t\tname\t\tfilecomponent");
        int i = 0;
        while (iter.hasRecord()) {
            DirectoryRecord record = iter.nextRecord();
            String path = CrailUtils.combinePath(record.getParent(), record.getFile());
            FileName hash = new FileName(path);
            System.out.format(i + ": %08d\t\t%s\t%d\n", record.isValid() ? 1 : 0, this.padRight(record.getFile(), 8), hash.getFileComponent());
            ++i;
        }
        iter.close();
        fs.closeFileSystem();
    }

    public void ping() throws Exception {
        CrailConfiguration conf = new CrailConfiguration();
        CrailConstants.updateConstants(conf);
        CoreDataStore fs = new CoreDataStore(conf);
        fs.ping();
        fs.closeFileSystem();
    }

    public void createDirectory(String filename, int storageClass, int locationClass) throws Exception {
        System.out.println("createDirectory, filename " + filename + ", storageClass " + storageClass + ", locationClass " + locationClass);
        CrailConfiguration conf = new CrailConfiguration();
        CrailStore fs = CrailStore.newInstance(conf);
        ((CrailNode)fs.create(filename, CrailNodeType.DIRECTORY, CrailStorageClass.get(storageClass), CrailLocationClass.get(locationClass), true).get()).syncDir();
        fs.close();
    }

    private String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    private void printStats(HashMap<String, AtomicInteger> stats) {
        for (String key : stats.keySet()) {
            System.out.println(key + "\t" + stats.get(key));
        }
    }

    private void walkBlocks(HashMap<String, AtomicInteger> stats, CrailStore fs, String filePath, long offset, long len) throws Exception {
        CrailBlockLocation[] locations = ((CrailNode)fs.lookup(filePath).get()).asFile().getBlockLocations(offset, len);
        for (int i = 0; i < locations.length; ++i) {
            for (int j = 0; j < locations[i].getNames().length; ++j) {
                String name = locations[i].getNames()[j];
                String host = name.split(":")[0];
                this.incStats(stats, host);
            }
        }
    }

    private void incStats(HashMap<String, AtomicInteger> stats, String host) {
        if (!stats.containsKey(host)) {
            stats.put(host, new AtomicInteger(0));
        }
        stats.get(host).incrementAndGet();
    }

    public static void main(String[] args) throws Exception {
        String type = "";
        String filename = "/tmp.dat";
        long offset = 0L;
        long length = 1L;
        boolean randomize = false;
        int storageClass = 0;
        int locationClass = 0;
        Option typeOption = Option.builder((String)"t").desc("type of experiment [getLocations|directoryDump|namenodeDump|blockStatistics|ping|createDirectory]").hasArg().build();
        Option fileOption = Option.builder((String)"f").desc("filename").hasArg().build();
        Option offsetOption = Option.builder((String)"y").desc("offset into the file").hasArg().build();
        Option lengthOption = Option.builder((String)"l").desc("length of the file [bytes]").hasArg().build();
        Option storageOption = Option.builder((String)"c").desc("storageClass for file [1..n]").hasArg().build();
        Option locationOption = Option.builder((String)"p").desc("locationClass for file [1..n]").hasArg().build();
        Options options = new Options();
        options.addOption(typeOption);
        options.addOption(fileOption);
        options.addOption(offsetOption);
        options.addOption(lengthOption);
        options.addOption(storageOption);
        options.addOption(locationOption);
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(options, Arrays.copyOfRange(args, 0, args.length));
        if (line.hasOption(typeOption.getOpt())) {
            type = line.getOptionValue(typeOption.getOpt());
        }
        if (line.hasOption(fileOption.getOpt())) {
            filename = line.getOptionValue(fileOption.getOpt());
        }
        if (line.hasOption(offsetOption.getOpt())) {
            offset = Long.parseLong(line.getOptionValue(offsetOption.getOpt()));
        }
        if (line.hasOption(lengthOption.getOpt())) {
            length = Long.parseLong(line.getOptionValue(lengthOption.getOpt()));
        }
        if (line.hasOption(storageOption.getOpt())) {
            storageClass = Integer.parseInt(line.getOptionValue(storageOption.getOpt()));
        }
        if (line.hasOption(locationOption.getOpt())) {
            locationClass = Integer.parseInt(line.getOptionValue(locationOption.getOpt()));
        }
        CrailFsck fsck = new CrailFsck();
        if (type.equals("getLocations")) {
            fsck.getLocations(filename, offset, length);
        } else if (type.equals("directoryDump")) {
            fsck.directoryDump(filename, randomize);
        } else if (type.equals("namenodeDump")) {
            fsck.namenodeDump();
        } else if (type.equals("blockStatistics")) {
            fsck.blockStatistics(filename);
        } else if (type.equals("ping")) {
            fsck.ping();
        } else if (type.equals("createDirectory")) {
            fsck.createDirectory(filename, storageClass, locationClass);
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("crail fsck", options);
            System.exit(-1);
        }
    }
}

