/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.metadata.BlockInfo;

public class BlockCache {
    private ConcurrentHashMap<Long, FileBlockCache> blockCache = new ConcurrentHashMap();

    public FileBlockCache getFileBlockCache(long fd) {
        FileBlockCache fileBlockCache = this.blockCache.get(fd);
        if (fileBlockCache == null) {
            fileBlockCache = new FileBlockCache(fd);
            FileBlockCache oldFileBlockCache = this.blockCache.putIfAbsent(fd, fileBlockCache);
            if (oldFileBlockCache != null) {
                fileBlockCache = oldFileBlockCache;
            }
        }
        return fileBlockCache;
    }

    public void remove(long fd) {
        this.blockCache.remove(fd);
    }

    public void purge() {
        this.blockCache.clear();
    }

    public static class FileBlockCache {
        private long fd;
        private ConcurrentHashMap<Long, BlockInfo> fileBlockCache;

        public FileBlockCache(long fd) {
            this.fd = fd;
            this.fileBlockCache = new ConcurrentHashMap();
        }

        public void put(long blockstart, BlockInfo block) {
            this.fileBlockCache.put(blockstart, block);
        }

        public BlockInfo get(long blockstart) {
            return this.fileBlockCache.get(blockstart);
        }

        public boolean containsKey(long blockstart) {
            return this.fileBlockCache.containsKey(blockstart);
        }

        public long getFd() {
            return this.fd;
        }
    }
}

